package com.liquidnet.client.admin.web.controller.zhengzai.order;

import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.kylin.service.IKylinOrderRefundsService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.constraints.NotNull;

@Api(tags = "ORDER 订单号")
@Slf4j
@Validated
@RestController
@RequestMapping("order/switch")
public class OrderSwitchAdminController {
    @Autowired
    IKylinOrderRefundsService kylinOrderRefundsService;

    @RequiresPermissions("order:switch:search:code")
    @ApiOperation(value = "开放/限制校验证码")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "code", value = "订单号", example = ""),
            @ApiImplicitParam(type = "form", required = true, dataType = "int", name = "type", value = "1退款单号 2订单号", example = ""),
    })
    @PostMapping("search/code")
    public ResponseDto<Object> loginSmsSwitch(@RequestParam @NotNull String code,@RequestParam @NotNull int type) {
        String codeNum = kylinOrderRefundsService.getOrderRefundCode(code,type);
        if(codeNum==null){
            return ResponseDto.success("未查询到");
        }else{
            return ResponseDto.success(codeNum);
        }
    }
}
