package com.liquidnet.service.candy.entity;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import java.util.Date;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 券基础信息
 * </p>
 *
 * @author liquidnet
 * @since 2021-08-18
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class CandyCoupon implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    private String couponId;

    /**
     * 券状态[0-INIT|1-NORMAL|2-INVALID]
     */
    private Integer state;

    /**
     * 券标题
     */
    private String title;

    /**
     * 标注
     */
    private String label;

    /**
     * 注意/须知
     */
    private String notice;

    /**
     * 专享标识[0-常规｜1-会员礼包]
     */
    private Integer exclusive;

    /**
     * 业务类别[0-全场｜1-演出｜2-商品｜3-优先购]
     */
    private Integer busiType;

    /**
     * 券类型[1-代金券｜2-满减券｜3-兑换券｜4-折扣券|101-优先券]
     */
    private Integer couType;

    /**
     * 领取方式[0-用户输入兑换｜1-发放至用户｜2-积分商品｜3-发放需领取｜4-会员专属]
     */
    private Integer bindType;

    /**
     * 折扣[8折即0.8]
     */
    private BigDecimal discount;

    /**
     * 面值
     */
    private BigDecimal valFace;

    /**
     * 满减~满
     */
    private BigDecimal valOver;

    /**
     * 满减~减
     */
    private BigDecimal valMinus;

    /**
     * 叠加限制[0-限制｜1-叠加]
     */
    private Integer overlay;

    /**
     * #同类别券叠加适用
     */
    private Integer overlayLevel;

    /**
     * 有效期（单位天）
     */
    private Integer validity;

    /**
     * 兑换有效期（单位天）
     */
    private Integer redeemValidity;

    /**
     * 兑换开放时间
     */
    private LocalDateTime redeemStart;

    /**
     * 兑换停止时间
     */
    private LocalDateTime redeemStop;

    /**
     * 生效时间
     */
    private LocalDateTime effectAt;

    /**
     * 过期时间
     */
    private LocalDateTime expireAt;

    /**
     * 操作人
     */
    private String operator;

    private LocalDateTime createdAt;

    private LocalDateTime updatedAt;

    private String comment;


}
