package com.liquidnet.service.goblin.dto.vo;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 预约表
 * </p>
 *
 * @author liquidnet
 * @since 2022-04-07
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class GoblinGoodsAnticipateVo implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 自增主键id
     */
    private Long id;

    /**
     * 预约名称
     */
    private String name;

    /**
     * 预约人数
     */
    private Long aboutPeople;

    /**
     * 实际预约人数
     */
    private Long actualPeople;

    /**
     * 预约开始时间
     */
    private LocalDateTime aboutStartDate;

    /**
     * 预约结束时间
     */
    private LocalDateTime aboutEndDate;

    /**
     * 创建时间
     */
    private LocalDateTime createdDate;

    /**
     * 删除（0:未删除1:已删除）
     */
    private Integer delTag;


}
