package com.liquidnet.service.account.common;

import org.springframework.util.StringUtils;

import java.util.HashMap;
import java.util.Map;

public class FinConstants {
    public static final String FUNDACCOUNT_SERVICE_VERSION = "1.0.0";
    public static final String SEQ_WL_NUMBER = "SEQ_WL_N01_";

    public static class Dashboard {
        public enum Period {
            L24H(24, "H", "%d-%b-%y/%H:00", "dd-MMM-yy/HH:mm", "Last 24 Hours"),
            L7D(24 * 7, "D", "%d-%b-%y", "dd-MMM-yy", "Last 7 Days"),
            L30D(24 * 30, "D", "%d-%b-%y", "dd-MMM-yy", "Last 30 Days"),
            ;
            private final int val;
            private final String tag;
            private final String fmt;
            private final String fmt2;
            private final String desc;

            Period(int val, String tag, String fmt, String fmt2, String desc) {
                this.val = val;
                this.tag = tag;
                this.fmt = fmt;
                this.fmt2 = fmt2;
                this.desc = desc;
            }

            public static Period byFmt(String v) {
                if (null != v) {
                    for (Period s : Period.values()) {
                        if (s.getFmt().equals(v)) {
                            return s;
                        }
                    }
                }
                return null;
            }

            public int getVal() {
                return val;
            }

            public String getTag() {
                return tag;
            }

            public String getFmt() {
                return fmt;
            }

            public String getFmt2() {
                return fmt2;
            }

            public String getDesc() {
                return desc;
            }
        }

        public enum Chart {
            All, Wallet_Balance
        }

        public enum Balance {
            All("All"),
            Pending("Pending Balance"),
            Available("Available Balance"),
            ;
            private final String val;

            Balance(String val) {
                this.val = val;
            }

            public String getVal() {
                return val;
            }
        }
    }

    public enum TransType {
        CREDIT_ONWAY("C", false),// pending++
        CREDIT_CONFIRM("C", true),// pending--,available++
        CREDIT_CANCEL("C", true),// pending--

        DEBIT_ONWAY("D", false),// available--,pending++
        DEBIT_CONFIRM("D", true),// pending--
        DEBIT_CANCEL("D", true),// available++,pending--
        ;
        private final String val;
        private final boolean force;

        TransType(String val, boolean force) {
            this.val = val;
            this.force = force;
        }

        public String getVal() {
            return val;
        }

        public boolean isForce() {
            return force;
        }
    }

    /**
     * 账本操作类型
     */
    public enum AccDetailOperType {
        /**
         * RECHARGE  充值
         * ONWAYRECHARGE 在途充值
         * FREEZE  冻结
         * LINKUNFREEZE  关联解冻
         * CUTPAYMENT  扣款
         * ONWAYPAYMENT 在途扣款
         * LINKRECHARGE  关联返还（充值退回）
         * CHARGEUP  挂账
         * ONWAYTRANS  内部转在途
         * OFFWAYTRANS  在途资金归集
         * LINKCHARGEOFF  关联销账
         * FEEFIRSTTRANSFER 首付款手续费
         * FEETRANSFER  转账手续费
         * FEEWITHDRAW  提现手续费
         * FEEBACK  冲正手续费
         * FEE  手续费
         **/
        RECHARGE(1, "RECHARGE"),
        LINKRECHARGE(1, "LINKRECHARGE"),
        ONWAYRECHARGE(1, "ONWAYRECHARGE"),

        FREEZE(1, "FREEZE"),
        LINKUNFREEZE(1, "LINKUNFREEZE"),

        CUTPAYMENT(1, "CUTPAYMENT"),
        ONWAYPAYMENT(1, "ONWAYPAYMENT"),

        CHARGEUP(1, "CHARGEUP"),
        LINKCHARGEOFF(1, "LINKCHARGEOFF"),

        ONWAYTRANS(1, "ONWAYTRANS"),
        OFFWAYTRANS(1, "OFFWAYTRANS"),

        FEEFIRSTTRANSFER(3, "FEEFIRSTTRANSFER"),
        FEETRANSFER(3, "FEETRANSFER"),
        FEEONWAYTRANSFER(3, "FEEONWAYTRANSFER"),
        FEEWITHDRAW(3, "FEEWITHDRAW"),
        FEEBACK(3, "FEEBACK"),

        FEE(2, "FEE"),
        ;

        private final String value;
        private final Integer level;

        private AccDetailOperType(Integer level, String value) {
            this.level = level;
            this.value = value;
        }

        private AccDetailOperType(String value) {
            this.level = 1;
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public Integer getLevel() {
            return level;
        }
    }

    /**
     * 交易业务类型
     * 根据业务需求和财务需求而定
     */
    public enum FundTradeType {

        RECHARGE("RECHARGE"),//充值（通用充值）
        WITHDRAW("WITHDRAW"),//提现（通用提现）
        FREEZE("FREEZE"),//冻结（通用冻结）
        UNFREEZE("UNFREEZE"),//解冻（通用解冻）
        CUTPAYMENT("CUTPAYMENT"),//扣款（通用扣款）
        EXCHANGE("EXCHANGE"),//汇兑（通用汇兑）
        TRANSFER("TRANSFER"),//转账（通用转账）
        FREEZE_EOS("FREEZE_EOS"),//EOS人工冻结
        UNFREEZE_EOS("UNFREEZE_EOS"),//EOS人工解冻
        ;

        private final String value;

        private FundTradeType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public enum TransferNature {
        B2B, B2C, C2C, C2B;

        public static TransferNature byValue(String v) {
            for (TransferNature s : TransferNature.values()) {
                if (s.name().equals(v)) {
                    return s;
                }
            }
            return null;
        }
    }

    public enum Dict {
        BIZ_TYPE, ACC_CURRENCY;
    }

    public enum AccType {
        AVAILABLE("000", "Available Balance"),
        PENDING("001", "Pending Balance"),
        FROZEN("002", "Frozen Balance"),
        ;
        private final String val;
        private final String desc;

        AccType(String val, String desc) {
            this.val = val;
            this.desc = desc;
        }

        public String getVal() {
            return val;
        }

        public String getDesc() {
            return desc;
        }

        public static AccType byVal(String v) {
            if (!StringUtils.isEmpty(v)) {
                for (AccType s : AccType.values()) {
                    if (s.getVal().equals(v)) {
                        return s;
                    }
                }
            }
            return null;
        }
    }

    public enum Status {
        INIT(0),
        NORMAL(1),
        DISABLE(2),
        ;
        private final int val;

        Status(int val) {
            this.val = val;
        }

        public int getVal() {
            return this.val;
        }

        public static Status byVal(Integer v) {
            if (null != v) {
                for (Status s : Status.values()) {
                    if (s.getVal() == v) {
                        return s;
                    }
                }
            }
            return null;
        }
    }

    /**
     * 业务交易状态
     */
    public enum TxStatus {
        PROCESSING(0),
        SUCCESS(1),
        FAILED(2),
        ;
        private final int val;

        TxStatus(int val) {
            this.val = val;
        }

        public int getVal() {
            return this.val;
        }
    }

    /**
     * 账户状态
     */
    public enum AccStatus {
        NORMAL(1, "正常"),
        NO_IN(2, "只出不进"),
        NO_OUT(3, "只进不出"),
        ARCHIVE(4, "封存"),
        ;
        private final int val;
        private final String desc;

        AccStatus(int val, String desc) {
            this.val = val;
            this.desc = desc;
        }

        public static AccStatus byVal(Integer v) {
            if (null != v) {
                for (AccStatus s : AccStatus.values()) {
                    if (s.getVal() == v) {
                        return s;
                    }
                }
            }
            return null;
        }

        public int getVal() {
            return this.val;
        }

        public String getDesc() {
            return desc;
        }

        public static final Map<Integer, String> map = new HashMap<Integer, String>();

        static {
            AccStatus[] vs = AccStatus.values();
            for (AccStatus v : vs) {
                map.put(v.getVal(), v.getDesc());
            }
        }
    }

    /**
     * 账户方类型
     */
    public enum AccFlag {
        /**
         * 企业\渠道类账户
         */
        BUSINESS("0"),
        /**
         * 个人用户类账户
         */
        PERSONAL("1"),
        ;
        private final String val;

        private AccFlag(String val) {
            this.val = val;
        }

        public String getVal() {
            return this.val;
        }
    }

    public enum CDType {
        CREDIT("C", "+"),
        DEBIT("D", "-"),
        ;
        private final String val;
        private final String tag;

        CDType(String val, String tag) {
            this.val = val;
            this.tag = tag;
        }

        public String getVal() {
            return val;
        }

        public String getTag() {
            return tag;
        }
    }

}
