package com.liquidnet.service.sweet.controller;


import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.sweet.service.ISweetActiveTypeService;
import com.liquidnet.service.sweet.service.ISweetAnswerService;
import com.liquidnet.service.sweet.vo.SweetAnswerVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * <p>
 * 答题表 前端控制器
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-08-12
 */
@Api(tags = "活动-二维码")
@RestController
@RequestMapping("/active")
public class SweetQrCodeController {

    @Autowired
    private ISweetActiveTypeService sweetActiveTypeService;

    @GetMapping("qrCode/type")
    @ApiOperation("获取答题记录详情")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", dataType = "int", name = "type", value = "活动type", required = true)
    })
    public ResponseDto<String> getRandomQrCode(int type) {
        return ResponseDto.success(sweetActiveTypeService.getRandomQrCode(type));
    }
}
