package com.liquidnet.service.kylin.dto.vo.returns;

import com.liquidnet.service.kylin.dto.vo.mongo.KylinOrderTicketVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

@Data
@ApiModel
public class KylinOrderListVo implements Serializable, Cloneable {
    private static final long serialVersionUID = 6554829077875538374L;
    @ApiModelProperty(value = "订单id", example = "")
    private String orderTicketsId;
    @ApiModelProperty(value = "演出id", example = "")
    private String performanceId;
    @ApiModelProperty(value = "票种id", example = "")
    private String ticketId;
    @ApiModelProperty(value = "演出标题", example = "")
    private String performanceTitle;
    @ApiModelProperty(value = "演出图片", example = "")
    private String performanceImg;
    @ApiModelProperty(value = "订单号", example = "")
    private String orderCode;
    @ApiModelProperty(value = "开售时间", example = "")
    private String timeStart;
    @ApiModelProperty(value = "票种名称", example = "")
    private String ticketTitle;
    @ApiModelProperty(value = "适用开始时间", example = "")
    private String useStart;
    @ApiModelProperty(value = "订单过期时间", example = "")
    private String overdueAt;
    @ApiModelProperty(value = "过期倒计时", example = "")
    private Long restTime;
    @ApiModelProperty(value = "实际支付价格", example = "")
    private BigDecimal priceActual;
    @ApiModelProperty(value = "数量", example = "")
    private Integer number;
    @ApiModelProperty(value = "订单状态(订单状态:0待付款，1已付款，2已关闭，3正在退款，4已退款, 5待关闭，6部分退款，" +
            "11转赠中,12已转增,13被转赠,14被赠中,15已退回,16被退回)", example = "")
    private Integer status;
    @ApiModelProperty(value = "快递状态", example = "")
    private Integer expressStatus;
    @ApiModelProperty(value = "取票方式", example = "")
    private String getTicketType;
    @ApiModelProperty(value = "创建时间", example = "")
    private String createdAt;

    private static final KylinOrderListVo obj = new KylinOrderListVo();

    public static KylinOrderListVo getNew() {
        try {
            return (KylinOrderListVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new KylinOrderListVo();
        }
    }

    public KylinOrderListVo copy(KylinOrderTicketVo vo) {
        if (null == vo) return this;

        this.orderTicketsId = vo.getOrderTicketsId();
        this.performanceId = vo.getPerformanceId();
        this.ticketId = vo.getTicketId();
        this.performanceTitle = vo.getPerformanceTitle();
        this.performanceImg = vo.getPerformanceImg();
        this.orderCode = vo.getOrderCode();
        this.timeStart = vo.getTimeStart();
        this.ticketTitle = vo.getTicketTitle();
        this.useStart = vo.getUseStart();
        this.overdueAt = vo.getOverdueAt();
        this.priceActual = vo.getPriceActual();
        this.number = vo.getNumber();
        this.expressStatus = 0;
        this.getTicketType = vo.getGetTicketType();
        this.createdAt = vo.getCreatedAt();
        this.restTime = 0L;
        if (vo.getTransferStatus().equals(1)) {
            this.status = 11;
        }
        if (vo.getTransferStatus().equals(2)) {
            this.status = 12;
        }
        if (vo.getTransferStatus().equals(3)) {
            this.status = 13;
        }
        if (vo.getTransferStatus().equals(4)) {
            this.status = 14;
        }
        if (vo.getTransferStatus().equals(5)) {
            this.status = 15;
        } else if (vo.getTransferStatus().equals(6)) {
            this.status = 16;
        } else {
            this.status = vo.getStatus();
        }
        return this;
    }
}
