package com.liquidnet.service.goblin.service.manage;

import com.github.pagehelper.PageInfo;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.dto.manage.GoblinGoodsAnticipateAddParam;
import com.liquidnet.service.goblin.dto.manage.GoblinGoodsAnticipateValueParam;
import com.liquidnet.service.goblin.dto.manage.vo.AnticipateValueVo;
import com.liquidnet.service.goblin.dto.manage.vo.GoblinGoodsAnticipateValueVo;

import java.math.BigInteger;

/**
 * <p>
 * 预约表 服务类
 * </p>
 *
 * @author liquidnet
 * @since 2022-04-07
 */
public interface IGoblinGoodsAnticipateMgService {

    /**
     * 查询预约
     */
    ResponseDto<PageInfo<GoblinGoodsAnticipateValueVo>> list(GoblinGoodsAnticipateValueParam goodsAnticipateValueParam);

    /**
     * 新增预约
     */
    ResponseDto<Object> add(GoblinGoodsAnticipateAddParam goodsAnticipateAddParam);

    /**
     * 修改预约人数
     */
    ResponseDto<Boolean> updatePeople(String antId, BigInteger people);

    /**
     * 删除预约
     */
    ResponseDto<Boolean> delete(String skuId);

    AnticipateValueVo getAnticipateValueBySkuId(String skuId,int hasHead);
}
