package com.liquidnet.service.kylin.dto.param;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;


/**
 * 修改场地全部显示数据参数
 */
@Data
public class FieldsSearchParam implements Serializable {
    @ApiModelProperty(value = "场地名称", example = "")
    private String name;

    @ApiModelProperty(value = "省名称", example = "")
    private String provinceName;

    @ApiModelProperty(value = "城市名称", example = "")
    private String cityName;

    @ApiModelProperty(value = "县名称", example = "")
    private String districtName;

    @ApiModelProperty(value = "认证状态 -1全部 0未认证 1已认证", example = "-1")
    private Integer validStatus;

    @ApiModelProperty(value = "是否显示 -1全部 0不显示 1显示", example = "-1")
    private Integer isDisplay;

    @ApiModelProperty(value = "是否营业 -1全部 0不营业 1营业中", example = "-1")
    private Integer isBusiness;

    @ApiModelProperty(value = "审核状态 -1全部 0待审核 1已审核 2被拒绝", example = "-1")
    private Integer changeStatus;

    @ApiModelProperty(value = "排序类型 1创建时间 1修改时间 ", example = "1")
    private Integer orderType;

    @ApiModelProperty(value = "页数 ", example = "1")
    private Integer page;

    @ApiModelProperty(value = "数量 ", example = "10")
    private Integer size;

    @JsonIgnore
    private Integer provinceId;

    @JsonIgnore
    private Integer cityId;

    @JsonIgnore
    private Integer districtId;
}
