package com.liquidnet.service.galaxy.dto.param;

import com.liquidnet.commons.lang.util.JsonUtils;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: 发行+购买结果查询
 * @class: GalaxyNftPublishResultQueryRespDto
 * @Package com.liquidnet.service.galaxy.dto.param
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/3/28 11:22
 */
@ApiModel(value = "GalaxyNftPublishAndBuyResultBatchQueryRespDto", description = "NFT发行结果查询")
@Data
public class GalaxyNftPublishAndBuyResultBatchQueryRespDto implements Serializable,Cloneable {
    @ApiModelProperty(position = 1, required = true, value = "用户购买信息List")
    private List<GalaxyNftPublishAndBuyResultQueryRespDto> routerBuyInfoList;

    @Override
    public String toString() {
        return JsonUtils.toJson(this);
    }

    private static final GalaxyNftPublishAndBuyResultBatchQueryRespDto obj = new GalaxyNftPublishAndBuyResultBatchQueryRespDto();

    public static GalaxyNftPublishAndBuyResultBatchQueryRespDto getNew() {
        try {
            return (GalaxyNftPublishAndBuyResultBatchQueryRespDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GalaxyNftPublishAndBuyResultBatchQueryRespDto();
        }
    }
}
