package com.liquidnet.service.adam.dto.vo;

import com.liquidnet.commons.lang.util.SensitizeUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@ApiModel(value = "AdamRealInfoVo", description = "实名信息")
@Data
public class AdamRealInfoVo implements Serializable, Cloneable {
    private static final long serialVersionUID = -3469256375584132928L;
    @ApiModelProperty(position = 11, value = "姓名[30]")
    private String name;
    @ApiModelProperty(position = 12, value = "证件号[50]")
    private String idCard;
    @ApiModelProperty(position = 13, value = "状态:1-正常")
    private Integer state;

    private static final AdamRealInfoVo obj = new AdamRealInfoVo();

    public static AdamRealInfoVo getNew() {
        try {
            return (AdamRealInfoVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new AdamRealInfoVo();
    }

    public String getName() {
        return SensitizeUtil.chineseName(name);
    }

    public String getIdCard() {
        return SensitizeUtil.custom(idCard, 3, 2);
    }
}
