package com.liquidnet.service.adam.dto.vo;

import com.liquidnet.service.adam.entity.AdamEnters;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@ApiModel(value = "AdamEntersVo", description = "入场人")
@Data
public class AdamEntersVo implements java.io.Serializable, Cloneable {
    private static final long serialVersionUID = 5258094625450569125L;
    @ApiModelProperty(position = 10, value = "入场人ID[64]")
    private String entersId;
    @ApiModelProperty(position = 11, value = "入场人名称[50]")
    private String name;
    @ApiModelProperty(position = 12, value = "入场人手机号[11]")
    private String mobile;
    @ApiModelProperty(position = 13, value = "证件类型:1-大陆身份证,2-港澳通行证,3-台胞证,4-护照,5-军官证")
    private Integer type;
    @ApiModelProperty(position = 14, value = "入场人证件号[11]")
    private String idCard;
    @ApiModelProperty(position = 15, value = "是否为默认:0-否,1-是")
    private Boolean isDefault;

    private static final AdamEntersVo obj = new AdamEntersVo();

    public static AdamEntersVo getNew() {
        try {
            return (AdamEntersVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new AdamEntersVo();
    }

    public AdamEntersVo copy(AdamEnters source) {
        this.setEntersId(source.getEntersId());
        this.setName(source.getName());
        this.setIdCard(source.getIdCard());
        this.setMobile(source.getMobile());
        this.setType(source.getType());
        this.setIsDefault(source.getIsDefault());
        return this;
    }
}
