package com.liquidnet.service.adam.dto.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 会员价格
 */
@Data
public class AdamMemberPriceVo implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 会员价格ID
     */
    private String memberPriceId;

    /**
     * 会员类型ID
     */
    private String memberId;

    /**
     * 状态  0 不可用 1上线中 2已下线
     */
    private Integer status;

    /**
     * 会员包名称
     */
    private String name;

    /**
     * 原价
     */
    private BigDecimal price;

    /**
     * 折扣价
     */
    private BigDecimal priceFixed;

    /**
     * 会员包有效天数
     */
    private Integer days;

    /**
     * 会员包须知
     */
    private String detail;

    /**
     * 创建时间
     */
    private String createdAt;

    /**
     * 更新时间
     */
    private String updatedAt;
}
