package com.liquidnet.service.adam.controller;

import com.github.pagehelper.PageInfo;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import com.liquidnet.service.ResponseDto;
import com.liquidnet.service.adam.dto.AdamCollectParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

/**
 * <p>
 * 收藏 前端控制器
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-10
 */
@ApiSupport(order = 10050)
@Api(tags = "收藏")
@Slf4j
@RestController
@RequestMapping("collect")
public class AdamCollectionController {

    @ApiOperationSupport(order = 1)
    @ApiOperation(value = "添加收藏")
    @PostMapping("add")
    public ResponseDto<Object> add(@RequestBody AdamCollectParam parameter) {
        // TODO: 2021/4/28 数据校验、身份认证、获取登录UID
        String uid = "1";

        // TODO: 2021/5/10


        return ResponseDto.success();
    }

    @ApiOperationSupport(order = 2)
    @ApiOperation(value = "删除收藏")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "type", value = "收藏类型", allowableValues = "VIDEO,TICKET,SITE,ARTIST,BAND,BRAND,STYLE,GOODS,MUSIC,SONG"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "contentId", value = "内容ID[64]"),
    })
    @PostMapping("del")
    public ResponseDto<Object> del(@RequestParam String type, @RequestParam String contentId) {
        // TODO: 2021/4/28 数据校验、身份认证、获取登录UID
        String uid = "1";

        // TODO: 2021/5/10


        return ResponseDto.success();
    }

    @ApiOperationSupport(order = 3)
    @ApiOperation(value = "收藏列表 -> 返回结构待定:遵循原PHP.API查询Collection内容")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "type", value = "收藏类型", allowableValues = "VIDEO,TICKET,SITE,ARTIST,BAND,BRAND,STYLE,GOODS,MUSIC,SONG"),
            @ApiImplicitParam(type = "form", required = true, dataType = "Integer", name = "pageNum", value = "页展示条数"),
            @ApiImplicitParam(type = "form", required = true, dataType = "Integer", name = "pageSize", value = "页码"),
    })
    @PostMapping("list")
    public ResponseDto<PageInfo> list(@RequestParam String type, @RequestParam(defaultValue = "1") int pageNum, @RequestParam(defaultValue = "10") int pageSize) {
        // TODO: 2021/4/28 数据校验、身份认证、获取登录UID
        String uid = "1";

        // TODO: 2021/5/10


        return ResponseDto.success();
    }

    @ApiOperationSupport(order = 4)
    @ApiOperation(value = "获取特定内容的收藏用户列表 -> 返回结构待定")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "type", value = "收藏类型", allowableValues = "VIDEO,TICKET,SITE,ARTIST,BAND,BRAND,STYLE,GOODS,MUSIC,SONG"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "contentId", value = "内容ID[64]"),
    })
    @PostMapping("list/user")
    public ResponseDto<Object> listUser(@RequestParam String type, @RequestParam String contentId) {
        // TODO: 2021/4/28 数据校验、身份认证、获取登录UID
        String uid = "1";

        // TODO: 2021/5/10


        return ResponseDto.success();
    }

    @ApiOperationSupport(order = 5)
    @ApiOperation(value = "获取收藏状态")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "type", value = "收藏类型", allowableValues = "VIDEO,TICKET,SITE,ARTIST,BAND,BRAND,STYLE,GOODS,MUSIC,SONG"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "contentId", value = "内容ID[64]"),
    })
    @GetMapping("state")
    public ResponseDto<Object> state(@RequestParam String type, @RequestParam String contentId) {
        // TODO: 2021/4/28 数据校验、身份认证、获取登录UID
        String uid = "1";

        // TODO: 2021/5/10


        return ResponseDto.success();
    }
}
