package com.liquidnet.service.goblin.dto.manage;

import com.liquidnet.commons.lang.constant.LnsRegex;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.*;
import java.io.Serializable;
import java.math.BigDecimal;

@ApiModel(value = "GoblinStoreMgtCouponFilterParam", description = "商铺活动:优惠券列表信息")
@Data
public class GoblinStoreMgtCouponFilterParam implements Serializable {
    private static final long serialVersionUID = 7497421899123873674L;
    @ApiModelProperty(position = 10, required = true, value = "店铺ID[64]")
    @NotBlank(message = "店铺ID不能为空")
    private String storeId;
    @ApiModelProperty(position = 11, required = true, value = "当前记录起始索引", example = "1")
    @Min(value = 1, message = "起始索引无效")
    @NotNull(message = "起始索引无效")
    private Integer pageNum;
    @ApiModelProperty(position = 12, required = true, value = "每页显示记录数", example = "20")
    @Max(value = 100, message = "显示记录数无效")
    @NotNull(message = "显示记录数无效")
    private Integer pageSize;
    @ApiModelProperty(position = 13, required = false, value = "搜索关键字[50]")
    private String keyword;
    @ApiModelProperty(position = 14, required = false, value = "卡券编码[64]")
    private String storeCouponNo;
    @ApiModelProperty(position = 15, required = false, value = "卡券状态[0-等待开始|1-活动中|2-活动结束|3-停用]", allowableValues = "0,1,2,3")
    private Integer state;
    @ApiModelProperty(position = 16, required = false, value = "开始日期[YYYY-MM-DD]")
    @Pattern(regexp = LnsRegex.Valid.DATETIME_YMD, message = "开始日期格式有误")
    private String startTime;
    @ApiModelProperty(position = 17, required = false, value = "结束日期[YYYY-MM-DD]")
    @Pattern(regexp = LnsRegex.Valid.DATETIME_YMD, message = "结束日期格式有误")
    private String endTime;
    @ApiModelProperty(position = 18, required = false, value = "创建日期[YYYY-MM-DD]")
    @Pattern(regexp = LnsRegex.Valid.DATETIME_YMD, message = "创建日期格式有误")
    private String createdDt;
}
