package com.liquidnet.client.admin.zhengzai.kylin.service.impl;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.liquidnet.client.admin.zhengzai.kylin.mapper.KylinPerformancesMapper;
import com.liquidnet.client.admin.zhengzai.kylin.domain.KylinPerformances;
import com.liquidnet.client.admin.zhengzai.kylin.service.IKylinPerformancesService;
import com.liquidnet.client.admin.common.core.text.Convert;

/**
 * 演出Service业务层处理
 * 
 * @author ruoyi
 * @date 2021-05-24
 */
@Service
public class KylinPerformancesServiceImpl implements IKylinPerformancesService 
{
    @Autowired
    private KylinPerformancesMapper kylinPerformancesMapper;

    /**
     * 查询演出
     * 
     * @param mid 演出ID
     * @return 演出
     */
    @Override
    public KylinPerformances selectKylinPerformancesById(Long mid)
    {
        return kylinPerformancesMapper.selectKylinPerformancesById(mid);
    }

    /**
     * 查询演出列表
     * 
     * @param kylinPerformances 演出
     * @return 演出
     */
    @Override
    public List<KylinPerformances> selectKylinPerformancesList(KylinPerformances kylinPerformances)
    {
        return kylinPerformancesMapper.selectKylinPerformancesList(kylinPerformances);
    }

    /**
     * 新增演出
     * 
     * @param kylinPerformances 演出
     * @return 结果
     */
    @Override
    public int insertKylinPerformances(KylinPerformances kylinPerformances)
    {
        return kylinPerformancesMapper.insertKylinPerformances(kylinPerformances);
    }

    /**
     * 修改演出
     * 
     * @param kylinPerformances 演出
     * @return 结果
     */
    @Override
    public int updateKylinPerformances(KylinPerformances kylinPerformances)
    {
        return kylinPerformancesMapper.updateKylinPerformances(kylinPerformances);
    }

    /**
     * 删除演出对象
     * 
     * @param ids 需要删除的数据ID
     * @return 结果
     */
    @Override
    public int deleteKylinPerformancesByIds(String ids)
    {
        return kylinPerformancesMapper.deleteKylinPerformancesByIds(Convert.toStrArray(ids));
    }

    /**
     * 删除演出信息
     * 
     * @param mid 演出ID
     * @return 结果
     */
    @Override
    public int deleteKylinPerformancesById(Long mid)
    {
        return kylinPerformancesMapper.deleteKylinPerformancesById(mid);
    }
}
