package com.liquidnet.service.kylin.dto.param;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.liquidnet.commons.lang.util.DateUtil;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 推荐活动表
 * </p>
 *
 * @author liquidnet
 * @since 2022-07-27
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class KylinRecommendActiveParam implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "id")
    private Long mid;

    /**
     * 推荐活动id
     */
    @ApiModelProperty(value = "推荐活动id")
    private String recommendId;

    /**
     * 开启时间
     */
    @ApiModelProperty(value = "开启时间yyyy-MM-dd HH:mm:ss")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern= DateUtil.DATE_FULL_STR)
    private LocalDateTime startTime;

    /**
     * 结束时间
     */
    @ApiModelProperty(value = "结束时间yyyy-MM-dd HH:mm:ss")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern=DateUtil.DATE_FULL_STR)
    private LocalDateTime endTime;

    /**
     * 1NFT2组合购3演出4商品
     */
    @ApiModelProperty(value = "1NFT2组合购3演出4商品")
    private Integer activeType;

    /**
     * 活动绑定id
     */
    @ApiModelProperty(value = "活动绑定id")
    private String activeBindId;

    /**
     * 0未删除1已删除
     */
    @ApiModelProperty(value = "0未删除1已删除")
    private Integer delTag;

    /**
     * 创建时间
     */
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern=DateUtil.DATE_FULL_STR)
    @ApiModelProperty(value = "创建时间")
    private LocalDateTime createdAt;

    /**
     * 修改时间
     */
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern=DateUtil.DATE_FULL_STR)
    @ApiModelProperty(value = "修改时间")
    private LocalDateTime updatedAt;

    /**
     * 0开启，1未开启
     */
    @ApiModelProperty(value = "0开启，1未开启")
    private Integer status;


    private List<KylinRecommendActiveRelationParam> list;


}
