package com.liquidnet.service.kylin.service.impl;

import com.liquidnet.commons.lang.util.StringUtil;
import com.liquidnet.service.kylin.dto.vo.KylinRecommendActiveVo;
import com.liquidnet.service.kylin.dto.vo.mongo.KylinPerformanceVo;
import com.liquidnet.service.kylin.entity.KylinRecommendActive;
import com.liquidnet.service.kylin.service.IKylinRecommendActiveService;
import com.liquidnet.service.kylin.utils.DataUtils;
import com.liquidnet.service.kylin.utils.KylinRedisUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 人流量检测记录表 服务实现类
 * </p>
 *
 */
@Service
public class KylinRecommendActiveServiceImpl implements IKylinRecommendActiveService {
    @Autowired
    private DataUtils dataUtils;
    @Autowired
    private KylinRedisUtils kylinRedisUtils;

    @Override
    public List<KylinRecommendActiveVo> getRecommendById(List<KylinRecommendActive> list) {
        for(KylinRecommendActive kylinRecommendActive:list){
            KylinRecommendActiveVo kylinRecommendActiveVo = KylinRecommendActiveVo.getNew();
            BeanUtils.copyProperties(kylinRecommendActive,kylinRecommendActiveVo);

            if(StringUtil.isNotBlank(kylinRecommendActiveVo.getActiveBindId())&&null !=kylinRecommendActiveVo.getActiveType()){
                //找到绑定的详情
                if(kylinRecommendActiveVo.getActiveType()==3){
                    //演出
                    KylinPerformanceVo performancesInfo = dataUtils.getPerformanceVo(kylinRecommendActiveVo.getActiveBindId());
                }else if(kylinRecommendActiveVo.getActiveType()==1){
                    //NFT

                }else if(kylinRecommendActiveVo.getActiveType()==4){
                    //商品
                    kylinRedisUtils.getGoodsInfoVo(kylinRecommendActiveVo.getActiveBindId());
                }else if(kylinRecommendActiveVo.getActiveType()==2){

                }

            }

        }
        return null;
    }
    /*public GoblinNftGoodsSkuInfoVo getNft(String skuId){
        LocalDateTime now = LocalDateTime.now();
        HashMap<String, Object> map = kylinRedisUtils.getGoodsSkuInfoVo(now, skuId);
        if (null == map) {
            return null;
        }
        GoblinGoodsSkuInfoVo skuInfoVo = (GoblinGoodsSkuInfoVo) map.get("vo");
        Integer tagType = (Integer) map.get("tagType");
        String listId = (String) map.get("listId");
        LocalDateTime baseSaleStartTime = (LocalDateTime) map.get("baseSaleStartTime");
        LocalDateTime nextSaleStartTime = (LocalDateTime) map.get("nextSaleStartTime");
        if (goblinRedisUtils.getSkuAllStatusShow(skuInfoVo)) {
            //获取预约相关
            AnticipateValueVo anticipateValueVo = goblinGoodsAnticipateMgService.getAnticipateValueBySkuId(skuId, 1);

            GoblinNftGoodsSkuInfoVo nftGoodsSkuInfoVo = GoblinNftGoodsSkuInfoVo.getNew().copy(skuInfoVo, anticipateValueVo);
            // 限购数量
            Integer buyCount = 0;
            String userId = CurrentUtil.getCurrentUid();
            if (StringUtils.isNotBlank(userId)) {
                buyCount = goblinRedisUtils.getSkuCountByUid(userId, skuId);
            }
            if (null != skuInfoVo.getBuyLimit() && 0 != skuInfoVo.getBuyLimit()) {
                nftGoodsSkuInfoVo.setCanBuyNum(skuInfoVo.getBuyLimit() - buyCount);
            }
            // spu信息
            GoblinGoodsInfoVo goodsInfoVo = goblinRedisUtils.getGoodsInfoVo(skuInfoVo.getSpuId());
            GoblinNftGoodsDetailSpuInfoVo nftGoodsDetailSpuInfoVo = GoblinNftGoodsDetailSpuInfoVo.getNew().copy(goodsInfoVo);
            nftGoodsSkuInfoVo.setGoblinNftGoodsDetailSpuInfoVo(nftGoodsDetailSpuInfoVo);
            // 库存
            HashMap<String, Integer> stockHashMap = goblinOrderUtils.getIsStock(listId, skuId, skuInfoVo.getUnbox(), skuInfoVo.getSoldoutStatus(), goodsInfoVo.getSkuIdList());
            nftGoodsSkuInfoVo.setIsStock(stockHashMap.get("isStock"));
            // 总库存
            if (skuInfoVo.getUnbox().equals("1")) {
                nftGoodsSkuInfoVo.setSkuStock(stockHashMap.get("totalStock"));
            }
            // 系统时间
            nftGoodsSkuInfoVo.setSystime(LocalDateTime.now());
            nftGoodsSkuInfoVo.setTagType(tagType);
            nftGoodsSkuInfoVo.setListId(listId);
            nftGoodsSkuInfoVo.setBaseSaleStartTime(baseSaleStartTime);
            nftGoodsSkuInfoVo.setNextSaleStartTime(nextSaleStartTime);
            // 是否开启兑换
            nftGoodsSkuInfoVo.setIsExchange(goblinRedisUtils.getIsExchange(skuId));
            // 待支付订单数量
            nftGoodsSkuInfoVo.setNotPayNum(goblinRedisUtils.getNotPayNum(skuId, listId));
            return nftGoodsSkuInfoVo;
        } else {
            return null;
        }
    }*/
}
