package com.liquidnet.service.executor.main.handler;

import com.liquidnet.service.feign.goblin.task.FeignGoblinErpTaskClient;
import com.xxl.job.core.context.XxlJobHelper;
import com.xxl.job.core.handler.annotation.XxlJob;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * platform:goblin
 */
@Component
public class PlatformErpTaskHandler {
    @Autowired
    private FeignGoblinErpTaskClient feignGoblinErpTaskClient;

    //库存
    @XxlJob(value = "sev-platform:syncErpSpuStock")
    public void syncErpSpuStock() {
        try {
            XxlJobHelper.handleSuccess("结果：" + feignGoblinErpTaskClient.syncErpSpuStock("",Integer.parseInt(XxlJobHelper.getJobParam())).getData());
        } catch (Exception e) {
            XxlJobHelper.log(e);
            XxlJobHelper.handleFail();
        }
    }

    //订单
    @XxlJob(value = "sev-platform:syncErpSpuStock")
    public void pushErpTrade() {
        try {
            XxlJobHelper.handleSuccess("结果：" + feignGoblinErpTaskClient.pushErpTrade().getData());
        } catch (Exception e) {
            XxlJobHelper.log(e);
            XxlJobHelper.handleFail();
        }
    }

    //物流
    @XxlJob(value = "sev-platform:syncErpSpuStock")
    public void syncErpLogistic() {
        try {
            XxlJobHelper.handleSuccess("结果：" + feignGoblinErpTaskClient.syncErpLogistic().getData());
        } catch (Exception e) {
            XxlJobHelper.log(e);
            XxlJobHelper.handleFail();
        }
    }
}
