package com.liquidnet.service.stone.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.*;
import java.math.BigDecimal;
import java.time.LocalDateTime;

@ApiModel(value = "StoneItemBuildParam", description = "新建积分物品")
@Data
public class StoneItemBuildParam {
    @ApiModelProperty(required = false, value = "积分物品id[创建不传]", example = "1")
    private String itemId;
    @NotBlank(message = "目标物品不能为空")
    @ApiModelProperty(required = true, value = "目标物品id", example = "1")
    private String targetId;
    @NotBlank(message = "目标物品不能为空")
    @ApiModelProperty(required = true, value = "目标物品标题", example = "测试券1")
    private String targetTitle;
    @NotBlank(message = "展示图不能为空")
    @ApiModelProperty(required = true, value = "展示图", example = "https://image.baidu.com/search/albumsdetail?tn=albumsdetail&word=%E7%8C%AB&album_tab=%E5%8A%A8%E7%89%A9&album_id=692&rn=30&fr=searchresult&dyTabStr=MCwzLDYsMSw0LDUsOCw3LDIsOQ%3D%3D")
    private String img;
    @NotBlank(message = "所需积分不能为空")
    @ApiModelProperty(required = true, value = "所需积分", example = "10")
    private BigDecimal score;
    @NotBlank(message = "总库存不能为空")
    @ApiModelProperty(required = true, value = "总库存[-999-不限]", example = "100")
    private Integer generalTotal;
    @NotBlank(message = "限购数量为空")
    @ApiModelProperty(required = true, value = "限购数量[0-不限]", example = "1")
    private Integer limitCount;
    @NotBlank(message = "商品详情不能为空")
    @ApiModelProperty(required = true, value = "商品详情", example = "商品详情")
    private String details;
    @NotBlank(message = "注意事项不能为空")
    @ApiModelProperty(required = true, value = "注意事项", example = "注意事项")
    private String notice;
    @NotBlank(message = "上架状态不能为空")
    @ApiModelProperty(required = true, value = "上架状态[1-不限|2-定时|7-下线]", example = "1")
    private Integer status;
    @ApiModelProperty(required = false, value = "上架时间[status = 2 必传]", example = "2021-10-20T12:52:42")
    private String startTime;
    @ApiModelProperty(required = false, value = "下架时间[status = 2 必传]", example = "2021-10-21T12:52:42")
    private String endTime;

}
