package com.liquidnet.service.sweet.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.liquidnet.commons.lang.util.DateUtil;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

@Data
public class SweetActivityDrawListDao implements Serializable {

    private static final long serialVersionUID = 3465116974370295458L;

    /**
     * 抽奖id
     */
    private String drawId;

    /**
     * 关联活动id
     */
    private String integralActivityId;

    /**
     * 活动玩一次所需积分
     */
    private Integer activityNum;

    /**
     * 关联奖品id
     */
    private String prizeId;

    /**
     * 奖品名称
     */
    private String prizeTitle;

    /**
     * 奖品类型 1谢谢惠顾 2积分 3代金券 4满减券 5优先购买券 6实物
     */
    private Integer prizeType;

    /**
     * 关联id 如商品id 券id
     */
    private String relationId;

    /**
     * 单次奖励数量如积分 中奖给多少
     */
    private Integer prizeTypeNum;

    /**
     * 关联用户id
     */
    private String userId;

    /**
     * 关联用户手机号
     */
    private String mobile;

    /**
     * 关联用户昵称
     */
    private String nickname;

    /**
     * adam收货地址addresses_id
     */
    private String receivingAddressesId;

    /**
     * adam收货人姓名
     */
    private String receivingName;

    /**
     * adam收货人手机号
     */
    private String receivingPhone;

    /**
     * adam收货人完整地址 空格隔离省市区详细地址
     */
    private String receivingAddress;

    /**
     * 发放状态 1未发放 2已发放 3无需发放
     */
    private Integer receivingStatus;

    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern= DateUtil.DATE_FULL_STR)
    private LocalDateTime createdAt;
}
