package com.liquidnet.client.admin.zhengzai.kylin.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.service.kylin.constant.KylinTableStatusConst;
import com.liquidnet.service.kylin.entity.KylinOrderRefunds;
import com.liquidnet.service.kylin.entity.KylinOrderTicketEntities;
import com.liquidnet.service.kylin.entity.KylinOrderTickets;
import com.liquidnet.service.kylin.mapper.KylinOrderRefundsMapper;
import com.liquidnet.service.kylin.mapper.KylinOrderTicketEntitiesMapper;
import com.liquidnet.service.kylin.mapper.KylinOrderTicketsMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;

/**
 * <p>
 * 后台退款 服务实现类
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-05-25 19:50 下午
 */
@Service
public class KylinRefundExecuteServiceImpl {

    @Autowired
    private KylinOrderTicketsMapper kylinOrderTicketsMapper;

    @Autowired
    private KylinOrderRefundsMapper kylinOrderRefundsMapper;

    @Autowired
    private KylinOrderTicketEntitiesMapper kylinOrderTicketEntitiesMapper;

    @Autowired
    RedisUtil redisUtil;

    @Autowired
    private KylinRefundHttpSubmitServiceImpl kylinRefundHttpSubmitServiceImpl;

    @Async
    public void refundBatchApply(String targetId, String refundBatchId, HashMap<String, Object> otherParam) throws Exception {
        int count;
        int limitNum = 100;
        int mid = 0;
        do {
            List<KylinOrderTickets> orderList = kylinOrderTicketsMapper.getOrderEntities(targetId, mid, limitNum);

            for (KylinOrderTickets v : orderList) {
                List<KylinOrderTicketEntities> entitiesList = kylinOrderTicketEntitiesMapper.selectList(
                        new UpdateWrapper<KylinOrderTicketEntities>().eq("order_id", v.getOrderTicketsId())
                                .eq("is_payment", "yes")
                );
                // 请求php接口
                kylinRefundHttpSubmitServiceImpl.httpApply(v, entitiesList, otherParam, refundBatchId);
            }

            count = orderList.size();
            KylinOrderTickets lastInfo = orderList.get(count - 1);
            mid = lastInfo.getMid();
        } while (count >= limitNum);
    }

    @Async
    public void refundBatchStatus(String refundBatchId, HashMap<String, Object> otherParam) throws Exception {
        // 处理查询订单状态
        Integer[] whereStatus = {};
        Integer whereType = KylinTableStatusConst.ORDER_REFUND_TYPE_APPLY;
        switch ((String) otherParam.get("type")) {
            case "reapply":
                whereStatus = new Integer[]{KylinTableStatusConst.ORDER_REFUND_STATUS_REJECT, KylinTableStatusConst.ORDER_REFUND_STATUS_REFUSE};
                break;
            case "cancel":
                whereStatus = new Integer[]{KylinTableStatusConst.ORDER_REFUND_STATUS_APPLY, KylinTableStatusConst.ORDER_REFUND_STATUS_REJECT, KylinTableStatusConst.ORDER_REFUND_STATUS_REFUSE};
                break;
            case "review":
                if (otherParam.get("status") == KylinTableStatusConst.ORDER_REFUND_STATUS_APPROVED) { // 通过申请
                    whereStatus = new Integer[]{KylinTableStatusConst.ORDER_REFUND_STATUS_APPLY, KylinTableStatusConst.ORDER_REFUND_STATUS_REJECT, KylinTableStatusConst.ORDER_REFUND_STATUS_REFUSE};
                }
                if (otherParam.get("status") == KylinTableStatusConst.ORDER_REFUND_STATUS_REJECT) { // 驳回申请
                    whereStatus = new Integer[]{KylinTableStatusConst.ORDER_REFUND_STATUS_APPLY, KylinTableStatusConst.ORDER_REFUND_STATUS_APPROVED, KylinTableStatusConst.ORDER_REFUND_STATUS_REFUSE};
                }
                break;
            case "execute":
                if (otherParam.get("status") == KylinTableStatusConst.ORDER_REFUND_STATUS_UNFILLED) { // 执行退款
                    whereStatus = new Integer[]{KylinTableStatusConst.ORDER_REFUND_STATUS_APPROVED, KylinTableStatusConst.ORDER_REFUND_STATUS_REFUSE, KylinTableStatusConst.ORDER_REFUND_STATUS_ERROR};
                }
                if (otherParam.get("status") == KylinTableStatusConst.ORDER_REFUND_STATUS_REFUSE) { // 拒绝退款
                    whereStatus = new Integer[]{KylinTableStatusConst.ORDER_REFUND_STATUS_APPROVED, KylinTableStatusConst.ORDER_REFUND_STATUS_ERROR};
                }
                break;
            default:
                throw new Exception("type异常，无法操作");
        }

        int count;
        int limitNum = 1;
        int mid = 0;
        do {
            List<KylinOrderRefunds> refundList = kylinOrderRefundsMapper.getRefundList(whereType, refundBatchId, whereStatus, mid, limitNum);

            List<String> refundIds = null;
            if (!refundList.isEmpty()) {
                for (KylinOrderRefunds v : refundList) {
                    String refundId = v.getRefundId();
                    refundIds.add(refundId);
                }
                // 请求php接口
                kylinRefundHttpSubmitServiceImpl.httpStatus(refundIds, otherParam);
            }

            count = refundList.size();
            KylinOrderRefunds lastInfo = refundList.get(count - 1);
            mid = lastInfo.getMid();
        } while (count >= limitNum);
    }

}
