package com.liquidnet.service.account.wallet.controller;

import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.account.common.ErrorConstants;
import com.liquidnet.service.account.wallet.dto.WalletTransactionParam;
import com.liquidnet.service.account.wallet.dto.WalletTransactionQueryParam;
import com.liquidnet.service.account.wallet.dto.WalletTransactionQueryResult;
import com.liquidnet.service.account.wallet.dto.WalletTransactionResult;
import com.liquidnet.service.account.wallet.dto.base.WalletCallResult;
import com.liquidnet.service.account.wallet.dto.base.WalletContextParam;
import com.liquidnet.service.account.wallet.service.processor.WalletTransQueryProcessor;
import com.liquidnet.service.account.wallet.service.processor.WalletTransactionProcessor;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * WalletTransferController.class
 *
 * @author zhanggb
 * Created by IntelliJ IDEA at 2020/10/26
 */
@Api(tags = "Wallet Transfer")
@RestController
@RequestMapping("wl/transfer")
public class WalletTransferController {
    private static final Logger log = LoggerFactory.getLogger(WalletTransferController.class);
    @Autowired
    private WalletTransactionProcessor transactionProcessor;
    @Autowired
    private WalletTransQueryProcessor transQueryProcessor;

    @ApiOperationSupport(order = 1)
    @ApiOperation(value = "Wallet Transaction")
    @PostMapping("transaction")
    public WalletTransactionResult transaction(@RequestBody WalletTransactionParam parameter) {
        if (null == parameter) {
            return new WalletTransactionResult(ErrorConstants.PARAMS_VALUE_ERROR_CODE, ErrorConstants.PARAMS_VALUE_ERROR_DESC);
        }
        log.info("Call {}:[{}]", parameter.getClass().getSimpleName(), JsonUtils.toJson(parameter));
        WalletContextParam contextParam = WalletContextParam.getNew();
        BeanUtils.copyProperties(parameter, contextParam);
        contextParam.setTradeType(parameter.getClass().getSimpleName());
        WalletTransactionResult result = null;
        try {
            WalletCallResult<?> rst = transactionProcessor.service(contextParam);
            result = rst instanceof WalletTransactionResult ? (WalletTransactionResult) rst
                    : new WalletTransactionResult(rst.getCode(), rst.getMessage());
        } catch (Exception e) {
            log.error("Call {} handle exception:[{}]", parameter.getClass().getSimpleName(), JsonUtils.toJson(parameter), e);
            result = new WalletTransactionResult(ErrorConstants.WALLET_TRANS_ERROR_CODE, ErrorConstants.WALLET_TRANS_ERROR_DESC);
        }
        log.info("Call {}:[{}]", result.getClass().getSimpleName(), JsonUtils.toJson(result));
        result.setData(parameter);
        return result;
    }

    @ApiOperationSupport(order = 1)
    @ApiOperation(value = "Wallet transaction query")
    @PostMapping("transactionQuery")
    public WalletTransactionQueryResult transactionQuery(@RequestBody WalletTransactionQueryParam parameter) {
        if (null == parameter) {
            return new WalletTransactionQueryResult(ErrorConstants.PARAMS_VALUE_ERROR_CODE, ErrorConstants.PARAMS_VALUE_ERROR_DESC);
        }
        log.info("Call {}:[{}]", parameter.getClass().getSimpleName(), JsonUtils.toJson(parameter));
        WalletContextParam contextParam = WalletContextParam.getNew();
        BeanUtils.copyProperties(parameter, contextParam);
        contextParam.setTradeType(parameter.getClass().getSimpleName());
        WalletTransactionQueryResult result = null;
        try {
            WalletCallResult<?> rst = transQueryProcessor.service(contextParam);
            result = rst instanceof WalletTransactionQueryResult ? (WalletTransactionQueryResult) rst
                    : new WalletTransactionQueryResult(rst.getCode(), rst.getMessage());
        } catch (Exception e) {
            log.error("Call {} handle exception:[{}]", parameter.getClass().getSimpleName(), JsonUtils.toJson(parameter), e);
            result = new WalletTransactionQueryResult(ErrorConstants.WALLET_TRANS_ERROR_CODE, ErrorConstants.WALLET_TRANS_ERROR_DESC);
        }
        log.info("Call {}:[{}]", result.getClass().getSimpleName(), JsonUtils.toJson(result));
        result.setData(parameter);
        return result;
    }
}
