package com.liquidnet.service.bank.currencycloud.constant;

public class BankCcConversionConstants {

    public enum StatusEnum {
        AWAITING_FUNDS("awaiting_funds"),
        FUNDS_SENT("funds_sent"),
        FUNDS_ARRIVED("funds_arrived"),
        TRADE_SETTLED("trade_settled"),
        CLOSED("closed"),
        ;

        private String code;

        public static StatusEnum getEnumByCode(String code) {
            StatusEnum[] array = values();
            for (StatusEnum codeEnum : array) {
                if (codeEnum.code.equals(code)) {
                    return codeEnum;
                }
            }
            return null;
        }

        StatusEnum(String code) {
            this.code = code;
        }

        public String getCode() {
            return code;
        }

    }

}
