package com.liquidnet.commons.lang.core;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

import java.util.Date;
import java.util.Map;

@Data
@Component("jwtValidator")
@ConfigurationProperties(prefix = "jwt")
public class JwtValidator {
    private String ssoRedisKey = "adam:identity:sso:";
    private String secret;
    // 分钟
    private Long expireTtl;
    private Long refreshTtl;
    private Long blacklistGracePeriod;
//    private static final long EXPIRE_TIME = 15 * 60 * 1000;
//    private static final String TOKEN_SECRET = "qZHglvNP0n0aOOckHiQXq5JMD468J4eG";

    /**
     * 用户登录成功后生成Jwt token
     * 使用Hs256算法
     *
     * @param claimsMap 保存在Payload（有效载荷）中的内容
     * @return token字符串
     */
    public String create(Map<String, Object> claimsMap) {
        long nowMillis = System.currentTimeMillis();
        long expMillis = System.currentTimeMillis() + expireTtl * 60000;

        // 创建一个JwtBuilder，设置jwt的body
        JwtBuilder builder = Jwts.builder()
                // 保存在Payload（有效载荷）中的内容, 自定义一些数据保存在这里
                .setClaims(claimsMap)
                // iat: jwt的签发时间
                .setIssuedAt(new Date(nowMillis))
                // 设置过期时间
                .setExpiration(new Date(expMillis))
                // 使用HS256算法和签名使用的秘钥生成密文
                .signWith(SignatureAlgorithm.HS256, secret);
        return builder.compact();
    }

    /**
     * 解析token，获取到Payload（有效载荷）中的内容，包括验证签名，判断是否过期
     *
     * @param token 令牌
     * @return
     */
    public Claims parse(String token) {
        // 得到DefaultJwtParser
        return Jwts.parser()
                // 设置签名的秘钥
                .setSigningKey(secret)
                // 设置需要解析的token
                .parseClaimsJws(token).getBody();
    }
}
