package com.liquidnet.client.admin.web.controller.zhengzai.tools;

import com.liquidnet.client.admin.common.core.controller.BaseController;
import com.liquidnet.client.admin.common.core.domain.AjaxResult;
import com.liquidnet.client.admin.common.core.page.TableDataInfo;
import com.liquidnet.client.admin.common.utils.poi.ExcelUtil;
import com.liquidnet.client.admin.zhengzai.kylin.dto.OrderExportVo;
import com.liquidnet.client.admin.zhengzai.kylin.dto.OrderOutLineVo;
import com.liquidnet.client.admin.zhengzai.kylin.service.IExportService;
import com.liquidnet.client.admin.zhengzai.kylin.service.IToolService;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.kylin.dto.vo.mongo.KylinOrderTicketVo;
import com.liquidnet.service.kylin.entity.KylinOrderTicketEntities;
import org.bson.Document;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.*;
import com.liquidnet.service.kylin.entity.KylinOrderTickets;
import java.util.ArrayList;
import java.util.List;

@Controller
@RequestMapping("/tools")
public class ToolsBaseController extends BaseController {

    private String prefix = "zhengzai/tools";
    @Autowired
    private IExportService exportService;
    @Autowired
    private IToolService toolService;
    @Autowired
    MongoTemplate mongoTemplate;
    @GetMapping()
    public String tools() {
        return prefix + "/tools";
    }

    /**
     * 路径跳转
     *
     * @param id
     * @param mmap
     * @return
     */
    @GetMapping(value = "/details/{id}")
    public String detailsRoadShow(@PathVariable("id") Integer id, ModelMap mmap) {
        if (id == 1) {
            mmap.put("url", "/tools/export/mobile");
            return prefix + "/fun1";//导出手机号
        } else if (id == 2) {
            mmap.put("url_info", "/tools/order/enter");
            mmap.put("url_single", "/tools/order/getSingleEnter");
            return prefix + "/fun2";//订单修改入场人
        } else if (id == 3) {
            mmap.put("url_info", "/tools/order/getContacts");
            mmap.put("url_single", "/tools/order/getSingleContacts");
            return prefix + "/fun3";//订单查询
        }  else {
            return prefix + "/edit";
        }
    }

    /**
     * 导出手机号
     *
     * @param mobileType
     * @param performanceId
     * @return
     */
    @PostMapping("/export/mobile")
    @ResponseBody
    public AjaxResult exportMobile(Integer mobileType, String performanceId) {
        if (performanceId == null || performanceId.trim().equals("")) {
            return error("演出id有误");
        }

        List<OrderExportVo> list;
        if (mobileType == 1) {//购票用户
            list = exportService.exportOrderByPerformanceIdPay(performanceId);
        } else if (mobileType == 2) {//下单用户
            list = exportService.exportOrderByPerformanceIdAll(performanceId);
        } else {
            return error("查无订单");
        }
        if (list.size() == 0) {
            return error("查无订单");
        }
        ExcelUtil<OrderExportVo> util = new ExcelUtil(OrderExportVo.class);
        return util.exportExcel(list,  mobileType+"");
    }

    /**
     * 根据订单号获取入场人信息
     *
     * @param orderCode
     * @return
     */
    @PostMapping("/order/enter")
    @ResponseBody
    public TableDataInfo getOrderTicketEnterByOrderCode(String orderCode, ModelMap mmap) {
        List<KylinOrderTicketEntities> data = toolService.getOrderTicketEnterByOrderCode(orderCode);
        TableDataInfo rspData = new TableDataInfo();
        rspData.setCode(0);
        if (data != null) {
            rspData.setRows(data);
            rspData.setTotal(data.size());
        } else {
            rspData.setRows(new ArrayList<>());
            rspData.setTotal(0);
        }
        return rspData;
    }

    /**
     * 根据票单id查询票单入场人
     *
     * @param orderTicketEntitiesId
     * @return
     */
    @GetMapping("/order/getSingleEnter/{orderTicketEntitiesId}")
    public String getSingleEnter(@PathVariable("orderTicketEntitiesId") String orderTicketEntitiesId, ModelMap mmap) {
        KylinOrderTicketEntities data = toolService.getSingleEnter(orderTicketEntitiesId);
        mmap.put("dataInfo", data);
        mmap.put("url_change", "/tools/order/enterChange");
        return prefix + "/fun2Details";
    }

    /**
     * 根据订单号获取入场人信息
     *
     * @param orderId
     * @return
     */
    @PostMapping("/order/enterChange")
    @ResponseBody
    public AjaxResult getOrderTicketEnterByOrderCode(String orderTicketEntitiesId, String enterName, String enterMobile, String enterIdCode, Integer enterType, String orderId) {
        return AjaxResult.success(toolService.supplementEnter(orderTicketEntitiesId, enterName, enterMobile, enterIdCode, enterType, orderId));
    }

    /**
     * 根据订单号获取收货人信息
     *
     * @param orderCode
     * @return
     */
    @PostMapping("/order/getContacts")
    @ResponseBody
    public TableDataInfo getExpressContactsByOrderCode(String orderCode, ModelMap mmap) {
        TableDataInfo rspData = new TableDataInfo();
        rspData.setCode(0);
        List<KylinOrderTickets> data = toolService.getExpressContactsByOrderCode(orderCode);
        if (data != null){
            rspData.setRows(data);
            rspData.setTotal(data.size());
        }else {
            rspData.setRows(new ArrayList<>());
            rspData.setTotal(0);
        }
        return rspData;
    }
    /**
     * 修改收货人信息
     *
     * @param orderCode
     * @return
     */
    @GetMapping("/order/getSingleContacts/{orderCode}")
    public String getSingleContacts(@PathVariable("orderCode") String orderCode, ModelMap mmap) {
        List<KylinOrderTickets> data = toolService.getExpressContactsByOrderCode(orderCode);
        mmap.put("dataInfo", data.get(0));
        mmap.put("url_change", "/tools/order/expressPhoneChange");
        return prefix + "/fun3Details";
    }
    /**
     * 修改收货人手机号
     *
     * @param orderCode
     * @param expressPhone
     * @return
     */
    @PostMapping("/order/expressPhoneChange")
    @ResponseBody
    public AjaxResult updOrderExpressPhoneByOrderCode(String orderCode,String expressPhone) {
        return AjaxResult.success(toolService.updOrderExpressPhoneByOrderCode(orderCode, expressPhone));
    }

}
