package com.liquidnet.common.third.zxlnft.dto;

import lombok.Data;

import java.io.Serializable;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: 50.NFT销售状态变更
 * @class: NftStatusUpdateReq
 * @Package com.liquidnet.common.third.zxlnft.dto.nft
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/2/18 15:58
 */
@Data
public class Nft050StatusUpdateReqDto implements Serializable {
    /**
     * 平台公钥
     */
    private String platformPubKey;
    /**
     * 操作者公钥
     */
    private String operatorPubKey;
    /**
     * 要操作的nftId
     */
    private String nftId;
    /**
     * 销售状态， 1:可售状态 2:非可售状态
     */
    private Integer transStatus;
    /**
     * 销售价格(默认为0，状态为可售时不能为0)
     */
    private Integer transPrice;
    /**
     * 请求ID，每个请求需要填唯一的ID，重复请求用相同的id
     */
    private String operateId;
    /**
     * 操作者的私钥签名，签名对象是(platformPubKey_operatorPubKey_接口名_nftId_transStatus_transPrice_operateId)
     * 接口名： nft_update_sell
     */
    private String signature;
    /**
     * 平台方的私钥签名，签名对象和signature对象一致
     */
    private String platformSignature;
    private static final Nft050StatusUpdateReqDto obj = new Nft050StatusUpdateReqDto();
    private static final long serialVersionUID = -7751451650648018342L;

    public static Nft050StatusUpdateReqDto getNew() {
        try {
            return (Nft050StatusUpdateReqDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new Nft050StatusUpdateReqDto();
        }
    }
}
