-- 创建手环产品表
CREATE TABLE IF NOT EXISTS goblin_recharge_wristband
(
    mid          BIGINT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    wristband_id VARCHAR(64)    NOT NULL DEFAULT '' COMMENT '手环ID',
    name         VARCHAR(255)   NOT NULL DEFAULT '' COMMENT '手环名称',
    price        DECIMAL(10, 2) NOT NULL DEFAULT 0 COMMENT '手环价格',
    created_at   timestamp      NULL     DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    updated_at   timestamp      NULL     DEFAULT CURRENT_TIMESTAMP COMMENT '更新时间'
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4 COMMENT ='手环信息表';

-- 创建充值金额表
CREATE TABLE IF NOT EXISTS goblin_recharge_amount
(
    mid        BIGINT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    amount_id  VARCHAR(64)    NOT NULL DEFAULT '' COMMENT '金额ID',
    name       VARCHAR(255)   NOT NULL DEFAULT '' COMMENT '金额名称',
    price      DECIMAL(10, 2) NOT NULL DEFAULT 0 COMMENT '充值金额',
    created_at timestamp      NULL     DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    updated_at timestamp      NULL     DEFAULT CURRENT_TIMESTAMP COMMENT '更新时间'
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4 COMMENT ='充值金额选项表';