package com.liquidnet.service.goblin.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.service.goblin.dto.vo.GoblinRechargeAmountVo;
import com.liquidnet.service.goblin.dto.vo.GoblinRechargeWristbandVo;
import com.liquidnet.service.goblin.entity.GoblinRechargeAmount;
import com.liquidnet.service.goblin.entity.GoblinRechargeWristband;
import com.liquidnet.service.goblin.mapper.GoblinRechargeAmountMapper;
import com.liquidnet.service.goblin.mapper.GoblinRechargeWristbandMapper;
import com.liquidnet.service.goblin.service.IGoblinRechargeWristbandService;
import com.liquidnet.service.goblin.util.GoblinRedisUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 * 手环信息表 服务实现类
 * </p>
 *
 * @author jiangxiulong
 * @since 2025-07-03
 */
@Service
public class GoblinRechargeWristbandServiceImpl extends ServiceImpl<GoblinRechargeWristbandMapper, GoblinRechargeWristband> implements IGoblinRechargeWristbandService {

    @Autowired
    GoblinRedisUtils goblinRedisUtils;

    @Autowired
    private GoblinRechargeAmountMapper rechargeAmountMapper;

    @Autowired
    private GoblinRechargeWristbandMapper rechargeWristbandMapper;

    @Override
    public GoblinRechargeWristbandVo getList() {
        GoblinRechargeWristbandVo result = goblinRedisUtils.getRechargeWristbandVo();

        if (result == null) {
            // 从数据库中查询数据
            List<GoblinRechargeWristband> rechargeWristbands = rechargeWristbandMapper.selectList(null);
            List<GoblinRechargeAmount> rechargeAmounts = rechargeAmountMapper.selectList(null);

            // 组合数据
            if (!CollectionUtils.isEmpty(rechargeAmounts) && !CollectionUtils.isEmpty(rechargeWristbands)) {
                GoblinRechargeWristbandVo wristbandVo = GoblinRechargeWristbandVo.getNew();
                wristbandVo.setWristbandId(rechargeWristbands.get(0).getWristbandId());
                wristbandVo.setName(rechargeWristbands.get(0).getName());
                wristbandVo.setPrice(rechargeWristbands.get(0).getPrice());
                List<GoblinRechargeAmountVo> list = new ArrayList<>();
                for (GoblinRechargeAmount amount : rechargeAmounts) {
                    GoblinRechargeAmountVo amountVo = GoblinRechargeAmountVo.getNew();
                    amountVo.setAmountId(amount.getAmountId());
                    amountVo.setName(amount.getName());
                    amountVo.setPrice(amount.getPrice());
                    list.add(amountVo);
                }
                wristbandVo.setAmonutList(list);

                goblinRedisUtils.setRechargeWristbandVo(wristbandVo);
                return wristbandVo;
            }
        }

        return result;
    }

}