package com.liquidnet.service.galaxy.dto.param;

import com.liquidnet.commons.lang.util.JsonUtils;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;
import java.io.Serializable;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: NFT转让结果查询
 * @class: GalaxyNftTransferReqDto
 * @Package com.liquidnet.service.galaxy.dto.param
 * @Copyright: LightNet @ Copyright (c) 2022
 * @date 2022/8/15 14:42
 */
@ApiModel(value = "GalaxyNftTransferQueryReqDto", description = "NFT转让结果查询")
@Data
public class GalaxyNftTransferQueryReqDto extends GalaxyBaseReqDto implements Serializable,Cloneable {
    /**
     * nft转让流水号
     */
    @ApiModelProperty(position = 1, required = true, value = "nft转让流水号(保证唯一)，不超过30个字符")
    @NotBlank(message = "nft转让流水号(平台订单id)不能为空")
    @Size(min = 2, max = 30, message = "nft转让流水号(平台订单id)限制2-30位且不能包含特殊字符")
    private String transOrderId;

    @Override
    public String toString(){
        return JsonUtils.toJson(this);
    }

    private static final GalaxyNftTransferQueryReqDto obj = new GalaxyNftTransferQueryReqDto();

    public static GalaxyNftTransferQueryReqDto getNew() {
        try {
            return (GalaxyNftTransferQueryReqDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GalaxyNftTransferQueryReqDto();
        }
    }
}
