package com.liquidnet.service.goblin.dto.vo;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.liquidnet.service.base.PagedResult;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel(value = "GoblinDigitalArtworkPageVo", description = "我的藏品信息")
@JsonIgnoreProperties(ignoreUnknown = true)
public class GoblinDigitalArtworkPageVo implements Cloneable {
    private static final long serialVersionUID = -1510553574954846520L;
    @ApiModelProperty(position = 11, value = "藏品数量")
    private int artworkNum;
    @ApiModelProperty(position = 12, value = "藏品列表分页数据")
    private PagedResult<GoblinDigitalArtworkListVo> pagedResult;

    public int getArtworkNum() {
        return artworkNum;
    }

    public PagedResult<GoblinDigitalArtworkListVo> getPagedResult() {
        return pagedResult;
    }

    public GoblinDigitalArtworkPageVo setArtworkNum(int artworkNum) {
        this.artworkNum = artworkNum;
        return this;
    }

    public GoblinDigitalArtworkPageVo setPagedResult(PagedResult<GoblinDigitalArtworkListVo> pagedResult) {
        this.pagedResult = pagedResult;
        return this;
    }

    private static final GoblinDigitalArtworkPageVo obj = new GoblinDigitalArtworkPageVo();

    public static GoblinDigitalArtworkPageVo getNew() {
        try {
            return (GoblinDigitalArtworkPageVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinDigitalArtworkPageVo();
        }
    }
}
