package com.liquidnet.service.adam.dto.vo;

import com.liquidnet.service.adam.entity.AdamUserMember;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

@ApiModel(value = "AdamUserMemberVo", description = "会员用户信息")
@Data
public class AdamUserMemberVo implements Serializable, Cloneable {
    private static final long serialVersionUID = 5258094625450569125L;

    @ApiModelProperty(position = 0, value = "用户id", example = "0")
    private String uid;
    @ApiModelProperty(position = 1, value = "会员类型id", example = "0")
    private String memberId;
    @ApiModelProperty(position = 2, value = "会员号", example = "0")
    private String memberNo;
    @ApiModelProperty(position = 3, value = "用户会员状态", example = "1")
    private Integer state;
    @ApiModelProperty(position = 4, value = "会员过期时间")
    private String expiryAt;
    @ApiModelProperty(position = 5, value = "创建时间")
    private String createdAt;
    @ApiModelProperty(position = 6, value = "更新时间")
    private String updatedAt;
    @ApiModelProperty(position = 7, value = "会员用户id")
    private String memberUserId;

    private static final AdamUserMemberVo obj = new AdamUserMemberVo();

    public static AdamUserMemberVo getNew() {
        try {
            return (AdamUserMemberVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new AdamUserMemberVo();
    }
}
