package com.liquidnet.service.kylin.dto.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;


/**
 * <p>
 * banner返回给前端的数据字段
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-05-03 11:19 上午
 */

@Data
@ApiModel
public class BannersVo implements Serializable {
    @ApiModelProperty(value = "Banner主键ID")
    private String bannersId;

    @ApiModelProperty(value = "标题")
    private String bannersName;

    @ApiModelProperty(value = "封面图")
    private String coverImg;

    @ApiModelProperty(value = "跳转类型 0: 1PGC点播 2 PGC直播 5场地 6票务 7商品 8巡演 12活动跳转-可分享 100活动跳转 13积分商品" +
            "14商品集合 20音乐人 21歌曲 22专辑 23视频播单 24音乐人集合 26摩登会员 201youngBlood报名跳转 0不跳转")
    private Integer targetType;

    @ApiModelProperty(value = "跳转目标id或者url")
    private String targetObj;

    @ApiModelProperty(value = "是否上线展示 0下线 1上线")
    private Integer isOnline;

    @ApiModelProperty(value = "上线开始时间")
    private String onlineStartTime;

    @ApiModelProperty(value = "上线结束时间")
    private String onlineEndTime;

    @ApiModelProperty(value = "推广类型 1全国 2省份")
    private Integer promotionType;

    @ApiModelProperty(value = "排序权重 越大越靠前")
    private Integer bannersSort;

    @ApiModelProperty(value = "备注")
    private String remarks;

    @ApiModelProperty(value = "展示的位置 多选 数组")
    private List positionList;

    @ApiModelProperty(value = "推广省份 多选 数组")
    private List provincesList;

    @ApiModelProperty(value = "城市名称")
    private List provincesNameList;

    @ApiModelProperty(value = "是否删除 0已删除,1正常")
    private Integer isDeleted;

    @ApiModelProperty(value = "创建时间")
    private String  createdAt;

    @ApiModelProperty(value = "修改时间")
    private String updatedAt;

}
