package com.liquidnet.service.feign.account.api;

import com.liquidnet.service.account.wallet.dto.*;
import com.liquidnet.service.account.wallet.dto.base.WalletCallResult;
import com.liquidnet.service.account.wallet.vo.WalletAccountInfoVo;
import feign.hystrix.FallbackFactory;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * Feign-API:liquidnet-service-account
 *
 * @author zhanggb
 * Created by IntelliJ IDEA at 2020/9/16
 */
@Component
@FeignClient(name = "liquidnet-service-account", contextId = "sev-account-main", path = "service-account", fallback = FallbackFactory.Default.class)
public interface FeignAccountClient {

    @RequestMapping(value = "wl/dashboard/show")
    WalletDashboardResult dashboardShow(WalletDashboardParam param);

    @RequestMapping(value = "wl/tx/trading")
    WalletCallResult<?> trading(String parameter);

    @RequestMapping(value = "wl/account/register")
    WalletRegisterResult register(WalletRegisterParam param);

    @RequestMapping(value = "wl/account/edit")
    WalletEditResult edit(WalletEditParam param);

    @RequestMapping(value = "wl/account/query")
    WalletQueryResult query(WalletQueryParam param);

    @RequestMapping(value = "wl/account/queryOne")
    WalletAccountInfoVo queryOne(@RequestParam("walletNo") String walletNo);

    @RequestMapping(value = "wl/transfer/transaction")
    WalletTransactionResult transaction(WalletTransactionParam param);

    @RequestMapping(value = "wl/transfer/transactionQuery")
    WalletTransactionQueryResult transactionQuery(WalletTransactionQueryParam param);
}
