package com.liquidnet.service.merchant.service.impl;

import com.liquidnet.service.merchant.dto.vo.*;
import com.liquidnet.service.merchant.service.IMerchantStationsService;
import com.liquidnet.service.merchant.service.MerchantRdmService;
import com.liquidnet.service.merchant.util.ObjectUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.Comparator;
import java.util.List;

@Slf4j
@Service
public class MerchantStationsServiceImpl implements IMerchantStationsService {

    @Autowired
    MerchantRdmService merchantRdmService;

    @Override
    public List<MerchantStationsVo> stationsList(String uid) {

        List<MerchantStationsVo> vos = ObjectUtil.getMerchantStationsVosArrayList();

        List<MerchantFieldAppliesVo> fieldAppliesVos = merchantRdmService.getFieldAppliesVosByUid(uid);
        if (!CollectionUtils.isEmpty(fieldAppliesVos)) {
            for (MerchantFieldAppliesVo fieldAppliesVo : fieldAppliesVos) {
                MerchantStationsVo vo = MerchantStationsVo.getNew();
                if (1 == fieldAppliesVo.getApplyStatus()) {
                    MerchantFieldsVo fieldsVo = merchantRdmService.getFieldsVoByFieldId(fieldAppliesVo.getFieldId());
                    vo.setStationType("field");
                    vo.setApplyStatus(fieldAppliesVo.getApplyStatus());
                    vo.setApplyType(fieldAppliesVo.getApplyType());
                    vo.setReject(fieldAppliesVo.getReject());
                    vo.setName(fieldsVo.getName());
                    vo.setLogo(fieldsVo.getLogo());
                    vo.setFieldApplyId(fieldAppliesVo.getFieldApplyId());
                    vo.setFieldId(fieldAppliesVo.getFieldId());
                    vo.setCreatedAt(fieldsVo.getCreatedAt());
                    vo.setUpdatedAt(fieldsVo.getUpdatedAt());
                } else {
                    vo.setStationType("fieldApply");
                    vo.setApplyStatus(fieldAppliesVo.getApplyStatus());
                    vo.setApplyType(fieldAppliesVo.getApplyType());
                    vo.setReject(fieldAppliesVo.getReject());
                    vo.setName(fieldAppliesVo.getName());
                    vo.setLogo(fieldAppliesVo.getLogo());
                    vo.setFieldApplyId(fieldAppliesVo.getFieldApplyId());
                    vo.setFieldId(fieldAppliesVo.getFieldId());
                    vo.setCreatedAt(fieldAppliesVo.getCreatedAt());
                    vo.setUpdatedAt(fieldAppliesVo.getUpdatedAt());
                }
                vos.add(vo);
            }
        }

        List<MerchantSponsorAppliesVo> sponsorAppliesVos = merchantRdmService.getSponsorAppliesVosByUid(uid);
        if (!CollectionUtils.isEmpty(sponsorAppliesVos)) {
            for (MerchantSponsorAppliesVo sponsorAppliesVo : sponsorAppliesVos) {
                MerchantStationsVo vo = MerchantStationsVo.getNew();
                if (1 == sponsorAppliesVo.getApplyStatus()) {
                    MerchantSponsorsVo sponsorsVo = merchantRdmService.getSponsorsVoBySponsorId(sponsorAppliesVo.getSponsorId());
                    vo.setStationType("sponsor");
                    vo.setApplyStatus(sponsorAppliesVo.getApplyStatus());
                    vo.setApplyType(sponsorAppliesVo.getApplyType());
                    vo.setReject(sponsorAppliesVo.getReject());
                    vo.setName(sponsorsVo.getName());
                    vo.setLogo(sponsorsVo.getLogo());
                    vo.setSponsorApplyId(sponsorAppliesVo.getSponsorApplyId());
                    vo.setSponsorId(sponsorAppliesVo.getSponsorId());
                    vo.setCreatedAt(sponsorsVo.getCreatedAt());
                    vo.setUpdatedAt(sponsorsVo.getUpdatedAt());
                } else {
                    vo.setStationType("sponsorApply");
                    vo.setApplyStatus(sponsorAppliesVo.getApplyStatus());
                    vo.setApplyType(sponsorAppliesVo.getApplyType());
                    vo.setReject(sponsorAppliesVo.getReject());
                    vo.setName(sponsorAppliesVo.getName());
                    vo.setLogo(sponsorAppliesVo.getLogo());
                    vo.setSponsorApplyId(sponsorAppliesVo.getSponsorApplyId());
                    vo.setSponsorId(sponsorAppliesVo.getSponsorId());
                    vo.setCreatedAt(sponsorAppliesVo.getCreatedAt());
                    vo.setUpdatedAt(sponsorAppliesVo.getUpdatedAt());
                }
                vos.add(vo);
            }
        }

        vos.sort(Comparator.comparing(MerchantStationsVo::getCreatedAt).reversed());

        return vos;
    }
}
