package com.liquidnet.service.goblin.controller.erp;

import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.service.IGoblinErpService;
import io.swagger.annotations.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;


@Api(tags = "erp-旺店通")
@RestController
@RequestMapping("wdt")
@Validated
public class WdtController {

    @Autowired
    IGoblinErpService goblinErpService;

    @PostMapping("syncErpSpuStock")
    @ApiOperation("同步库存")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = false, dataType = "String", name = "spuId", value = "spuId"),
            @ApiImplicitParam(type = "form", required = false, dataType = "Integer", name = "min", value = "间隔时间"),
    })
    public ResponseDto<Boolean> initErpStock(@RequestParam(value = "spuId", required = false) String spuId,
                                             @RequestParam(value = "min", required = false) Integer min) {
        if ( min == null || min <= 0) {
            min = 5;
        }
        return goblinErpService.initErpStock(spuId, min);
    }


    @PostMapping("pushErpTrade")
    @ApiOperation("推送订单")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = false, dataType = "String", name = "orderId", value = "orderId"),
    })
    public ResponseDto<Boolean> pushTrade(@RequestParam(value = "orderId", required = false) String orderId) {
        return goblinErpService.pushTrade(orderId);
    }

    @PostMapping("syncErpLogistic")
    @ApiOperation("同步物流")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<Boolean> syncErpLogistic() {
        return goblinErpService.syncErpLogistic();
    }

}
