package com.liquidnet.service.kylin.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 友盟消息推送
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-07-13
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class AdminUpush implements Serializable ,Cloneable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Integer mid;

    /**
     * upush_id
     */
    private String upushId;

    /**
     * 推送设备 1all 2ios 3android
     */
    private Integer pushRange;

    /**
     * 推送标题
     */
    private String pushTitle;

    /**
     * 推送内容
     */
    private String pushContent;

    /**
     * 封面图
     */
    private String img;

    /**
     * 跳转类型
     */
    private Integer jumpType;

    /**
     * 跳转值
     */
    private String jumpValue;

    /**
     * 跳转对应的值名称
     */
    private String jumpContent;

    /**
     * 推送时间
     */
    private String pushTime;

    /**
     * 是否发送推送消息，2不发送 1发送推送消息
     */
    private Integer isPush;

    /**
     * 发送类型，2立即发送 1定时发送
     */
    private Integer sendType;

    /**
     * 消息类型，2系统消息 1会员消息 会员不做了 默认2
     */
    private Integer messageType;

    /**
     * 用户类型，2全部用户 1指定手机号 指定手机不做了默认2
     */
    private Integer specifyType;

    /**
     * 消息展示类型，2普通文本，1图文排版
     */
    private Integer messageShowType;

    /**
     * 推送者ID
     */
    private String pushedBy;

    /**
     * 推送者姓名
     */
    private String pushedName;

    /**
     * 任务类消息(type为broadcast、groupcast、filecast、customizedcast且file_id不为空)返回
     */
    private String taskId;

    /**
     * 单播类消息(type为unicast、listcast、customizedcast且不带file_id)返回
     */
    private String msgId;

    /**
     * 错误码
     */
    private String errorCode;

    /**
     * 错误信息
     */
    private String errorMsg;

    private String createdAt;

    private String updatedAt;

    private static final AdminUpush obj = new AdminUpush();
    public static AdminUpush getNew() {
        try {
            return (AdminUpush) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new AdminUpush();
        }
    }
}
