package com.liquidnet.service.kylin.dto.vo.returns;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

@Data
public class KylinOrderTicketEntitiesPreRefundVo implements Serializable, Cloneable {
    private static final long serialVersionUID = 1207664465164005975L;
    private String orderTicketEntitiesId;
    private Integer enterType;
    private String enterName;
    private String enterMobile;
    private String enterIdCode;
    private Integer status;
    private String useStart;
    private String useEnd;
    private BigDecimal refundPrice;
    private BigDecimal priceActual;
    private BigDecimal priceCanRefund;
    private String ticketTitle;
    private Integer isPayment;
    @ApiModelProperty(value = "退款手续费比例 *100%")
    private BigDecimal chargesRatio;
    @ApiModelProperty(value = "退款手续费金额")
    private BigDecimal chargesPrice;

    private static final KylinOrderTicketEntitiesPreRefundVo obj = new KylinOrderTicketEntitiesPreRefundVo();
    public static KylinOrderTicketEntitiesPreRefundVo getNew() {
        try {
            return (KylinOrderTicketEntitiesPreRefundVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new KylinOrderTicketEntitiesPreRefundVo();
        }
    }
}
