package com.liquidnet.service.sweet.controller;

import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.sweet.constant.SweetConstant;
import com.liquidnet.service.sweet.mapper.SweetAnswerMapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

@Api(tags = "数据迁移")
@RestController
@RequestMapping("/sweetData")
@Slf4j
public class SweetDataController {

    @Autowired
    private SweetAnswerMapper sweetAnswerMapper;
    @Autowired
    private RedisUtil redisUtil;

//    @GetMapping("drawLuck")
//    @ApiOperation("中奖概率迁移")
//    public ResponseDto<String> drawLuck() {
//        try {
////            List<SweetUserTempVo> listHPFD = sweetAnswerMapper.selectHPFD();
////            for (SweetUserTempVo item : listHPFD) {
////                presentRedis(item.getMobile());
////            }
////            List<SweetUserTempVo> listHPWR = sweetAnswerMapper.selectHPWR();
////            for (SweetUserTempVo item : listHPWR) {
////                presentRedis(item.getMobile());
////            }
////            List<SweetUserTempVo> listHXC = sweetAnswerMapper.selectHXC();
////            for (SweetUserTempVo item : listHXC) {
////                presentRedis(item.getMobile());
////            }
////            List<SweetUserTempVo> listMember = sweetAnswerMapper.selectMember();
////            for (SweetUserTempVo item : listMember) {
////                presentRedis(item.getMobile());
////            }
//            List<SweetUserTempVo> listOrder1 = sweetAnswerMapper.selectOrder1();
//            for (SweetUserTempVo item : listOrder1) {
//                presentRedis(item.getMobile());
//            }
////            List<SweetUserTempVo> listOrder2 = sweetAnswerMapper.selectOrder2();
////            for (SweetUserTempVo item : listOrder2) {
////                presentRedis(item.getMobile());
////            }
////            List<SweetUserTempVo> listOrder3 = sweetAnswerMapper.selectOrder3();
////            for (SweetUserTempVo item : listOrder3) {
////                presentRedis(item.getMobile());
////            }
//            return ResponseDto.success();
//        } catch (Exception e) {
//            e.printStackTrace();
//            return ResponseDto.failure();
//        }
//    }

    @PostMapping("drawLuck/add")
    @ApiOperation("增加可中奖数量1最大6(20210820)")
    public ResponseDto<Boolean> luckDrawAllAdd() {
        try {
            String redisKey = SweetConstant.REDIS_KEY_SWEET_LUCK_DRAW_ALL.concat("20210820").concat(":all");
            int count = (int) redisUtil.get(redisKey);
            if (count >= 6) {
                redisUtil.set(redisKey, 6);
            } else {
                redisUtil.incr(redisKey, 1);
            }
            return ResponseDto.success();
        } catch (Exception e) {
            e.printStackTrace();
            return ResponseDto.failure();
        }
    }

    private void presentRedis(String mobile) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_LUCK_DRAW_PRESENT_MOBILE.concat(mobile);
        Object obj = redisUtil.get(redisKey);
        if (obj == null) {
            redisUtil.set(redisKey, 20);
        } else {
            redisUtil.incr(redisKey, 10);
        }
    }

}
