package com.liquidnet.client.admin.zhengzai.kylin.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.liquidnet.client.admin.common.utils.ShiroUtils;
import com.liquidnet.client.admin.common.utils.StringUtils;
import com.liquidnet.client.admin.zhengzai.kylin.utils.DataUtils;
import com.liquidnet.client.admin.zhengzai.kylin.utils.MongoVoUtils;
import com.liquidnet.commons.lang.util.HttpUtil;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.kylin.constant.KylinTableStatusConst;
import com.liquidnet.service.kylin.dto.param.RefundApplyParam;
import com.liquidnet.service.kylin.dto.param.RefundCallbackParam;
import com.liquidnet.service.kylin.dto.vo.mongo.KylinOrderTicketEntitiesVo;
import com.liquidnet.service.kylin.dto.vo.mongo.KylinOrderTicketVo;
import com.liquidnet.service.kylin.entity.*;
import com.liquidnet.service.kylin.mapper.*;
import com.mongodb.BasicDBObject;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.ReturnDocument;
import lombok.extern.slf4j.Slf4j;
import org.bson.Document;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>
 * 订单退款表 服务实现类 处理数据 退款后状态的变化
 * </p>
 *
 * @author jiaangxiulong
 * @since 2021-05-26
 */
@Slf4j
@Service
public class KylinRefundsStatusServiceImpl {

    @Value("${liquidnet.url-refund.apply}")
    private String applyUrl;
    @Value("${liquidnet.url-refund.notify}")
    private String notifyUrl;

    @Autowired
    private KylinOrderTicketsMapper kylinOrderTicketsMapper;

    @Autowired
    private KylinOrderTicketStatusMapper kylinOrderTicketStatusMapper;

    @Autowired
    private KylinOrderRefundsMapper kylinOrderRefundsMapper;

    @Autowired
    private KylinOrderTicketEntitiesMapper kylinOrderTicketEntitiesMapper;

    @Autowired
    private KylinOrderRefundsEntitiesMapper kylinOrderRefundsEntitiesMapper;

    @Autowired
    private KylinOrderTicketRelationsMapper kylinOrderTicketRelationsMapper;

    @Autowired
    MongoTemplate mongoTemplate;

    @Autowired
    private DataUtils dataUtils;

    @Autowired
    private MongoVoUtils mongoVoUtils;

    public Boolean orderTicketRefunding(
            RefundApplyParam refundApplyParam, KylinOrderTickets orderInfo, String orderTicketsId,
            double RefundPriceExpress,
            List<String> ticketEntityIds, List<Double> entitiesPrice
    ) {
        // 基础数据
        String authId = ShiroUtils.getUserId().toString();
        String authName = ShiroUtils.getLoginName();
        String reason = refundApplyParam.getReason();
        String orderRefundBatchesId = refundApplyParam.getOrderRefundBatchesId();
        // 本次退款票总金额
        double entitiesPriceSum = entitiesPrice.stream().mapToDouble(Double::doubleValue).sum();

        // TODO: 2021/5/27 事物 and 部分退款
        // 更新数据
        // 订单状态表 和 缓存
        KylinOrderTicketStatus orderStatusTable = new KylinOrderTicketStatus();
        orderStatusTable.setStatus(KylinTableStatusConst.ORDER_STATUS3);
        kylinOrderTicketStatusMapper.update(orderStatusTable, new UpdateWrapper<KylinOrderTicketStatus>()
                .eq("order_id", orderTicketsId));

        KylinOrderTicketVo kylinOrderTicketVo = new KylinOrderTicketVo();
        kylinOrderTicketVo.setStatus(KylinTableStatusConst.ORDER_STATUS3);
        BasicDBObject orderObject = new BasicDBObject("$set", JSON.parse(JsonUtils.toJson(kylinOrderTicketVo)));
        Document orderDoc = mongoTemplate.getCollection(KylinOrderTicketVo.class.getSimpleName()).findOneAndUpdate(
                Query.query(Criteria.where("orderTicketsId").is(orderTicketsId)).getQueryObject(),
                orderObject,
                new FindOneAndUpdateOptions().returnDocument(ReturnDocument.AFTER)
        );
        dataUtils.delOrderTicketRedis(orderTicketsId);
        mongoVoUtils.resetOrderListVo(orderInfo.getUserId(), 2, orderTicketsId,null);


        // 订单入场人表 和 缓存
        for (String v : ticketEntityIds) {
            KylinOrderTicketEntities entitiesTable = new KylinOrderTicketEntities();
            entitiesTable.setIsPayment(KylinTableStatusConst.ENTITIES_IS_PAYMENT2);
            kylinOrderTicketEntitiesMapper.update(entitiesTable, new UpdateWrapper<KylinOrderTicketEntities>()
                    .eq("order_ticket_entities_id", v));

            KylinOrderTicketEntitiesVo kylinOrderTicketEntitiesVo = new KylinOrderTicketEntitiesVo();
            kylinOrderTicketEntitiesVo.setIsPayment(KylinTableStatusConst.ENTITIES_IS_PAYMENT2);
            BasicDBObject entitiesObject = new BasicDBObject("$set", JSON.parse(JsonUtils.toJson(kylinOrderTicketEntitiesVo)));
            Document entitiesDoc = mongoTemplate.getCollection(KylinOrderTicketEntitiesVo.class.getSimpleName()).findOneAndUpdate(
                    Query.query(Criteria.where("orderTicketEntitiesId").is(v)).getQueryObject(),
                    entitiesObject,
                    new FindOneAndUpdateOptions().returnDocument(ReturnDocument.AFTER)
            );

            dataUtils.delOrderTicketEntitiesRedis(v);
        }

        // 退款明细
        KylinOrderRefunds kylinOrderRefunds = new KylinOrderRefunds();
        String orderRefundsId = IDGenerator.nextSnowId();
        kylinOrderRefunds.setOrderRefundsId(orderRefundsId);
        kylinOrderRefunds.setOrderTicketsId(orderTicketsId);
        kylinOrderRefunds.setOrderRefundBatchesId(orderRefundBatchesId);

        Integer refundCount = kylinOrderRefundsMapper.selectCount(
                new QueryWrapper<KylinOrderRefunds>()
                        .eq("order_tickets_id", orderTicketsId)
        );

        String orderRefundCode = orderInfo.getOrderCode();
        String codeNum = StringUtils.leftPad(String.valueOf(refundCount), 3, "0");
        kylinOrderRefunds.setOrderRefundCode(orderRefundCode.concat(codeNum));
        kylinOrderRefunds.setPrice(BigDecimal.valueOf(entitiesPriceSum));
        kylinOrderRefunds.setPriceExpress(BigDecimal.valueOf(RefundPriceExpress));
        kylinOrderRefunds.setStatus(KylinTableStatusConst.ORDER_REFUND_STATUS_APPLY);

        kylinOrderRefunds.setType(KylinTableStatusConst.ORDER_REFUND_TYPE_APPLY);
        kylinOrderRefunds.setApplicantId(authId);
        kylinOrderRefunds.setApplicantName(authName);
        kylinOrderRefunds.setApplicantAt(LocalDateTime.now());
        kylinOrderRefunds.setReason(reason);
        if (RefundPriceExpress > 0 && entitiesPriceSum > 0) {
            kylinOrderRefunds.setRefundCate(KylinTableStatusConst.ORDER_REFUND_CATE3);
        } else if (RefundPriceExpress > 0) {
            kylinOrderRefunds.setRefundCate(KylinTableStatusConst.ORDER_REFUND_CATE2);
        } else if (entitiesPriceSum > 0) {
            kylinOrderRefunds.setRefundCate(KylinTableStatusConst.ORDER_REFUND_CATE1);
        }
        kylinOrderRefunds.setCreatedAt(LocalDateTime.now());
        int rows = kylinOrderRefundsMapper.insert(kylinOrderRefunds);

        // 退款入场人表
        KylinOrderRefundEntities kylinOrderRefundEntities = new KylinOrderRefundEntities();
        for (int i = 0; i <= ticketEntityIds.size() - 1; i++) {
            String orderRefundsEntitiesId = IDGenerator.nextSnowId();
            kylinOrderRefundEntities.setOrderRefundsEntitiesId(orderRefundsEntitiesId);
            kylinOrderRefundEntities.setOrderRefundsId(orderRefundsId);
            kylinOrderRefundEntities.setRefundPrice(BigDecimal.valueOf(entitiesPrice.get(i)));
            kylinOrderRefundEntities.setOrderTicketEntitiesId(ticketEntityIds.get(i));
            kylinOrderRefundEntities.setCreatedAt(LocalDateTime.now());
            int rowsR = kylinOrderRefundsEntitiesMapper.insert(kylinOrderRefundEntities);
        }

        return true;
    }

    public boolean orderTicketRefundCancel(List<KylinOrderRefunds> refundList) {
        for (KylinOrderRefunds refundInfo : refundList) {
            List<KylinOrderRefundEntities> refundEntities = kylinOrderRefundsEntitiesMapper.selectList(
                    new QueryWrapper<KylinOrderRefundEntities>().eq("order_refunds_id", refundInfo.getOrderRefundsId())
            );
            List<String> orderTicketEntitiesIdsArr = refundEntities.stream().map(KylinOrderTicketEntities -> KylinOrderTicketEntities.getOrderTicketEntitiesId()).collect(Collectors.toList());
            String orderTicketsId = refundInfo.getOrderTicketsId();
            String orderRefundsId = refundInfo.getOrderRefundsId();

            // 更新数据
            // 订单状态表 判断是退到正在退款 已付款 部分退款？(取消，完成，失败)
            int newStatus = 0;
            Integer[] whereRefundingCount = {KylinTableStatusConst.ORDER_STATUS2, KylinTableStatusConst.ORDER_STATUS4, KylinTableStatusConst.ORDER_STATUS6};
            int refundingCount = kylinOrderRefundsMapper.selectCount(
                    new QueryWrapper<KylinOrderRefunds>().eq("order_tickets_id", orderTicketsId)
                    .notIn("status", whereRefundingCount)
                    .ne("order_refunds_id", orderRefundsId)

            );
            if (refundingCount > 0) { // 存在其他正在退款的订单
                newStatus = KylinTableStatusConst.ORDER_STATUS3;
            } else {
                KylinOrderTickets orderInfo = kylinOrderTicketsMapper.selectOne(
                        new QueryWrapper<KylinOrderTickets>().eq("order_tickets_id", orderTicketsId)
                );
                if (orderInfo.getPriceRefund().doubleValue() > 0) { // 已经有退完的 那就是部分退款了
                    newStatus = KylinTableStatusConst.ORDER_STATUS6;
                } else {
                    newStatus = KylinTableStatusConst.ORDER_STATUS1;
                }
            }

            KylinOrderTicketStatus orderStatusTable = new KylinOrderTicketStatus();
            orderStatusTable.setStatus(newStatus);
            kylinOrderTicketStatusMapper.update(orderStatusTable, new UpdateWrapper<KylinOrderTicketStatus>()
                    .eq("order_id", orderTicketsId));

            KylinOrderTicketVo kylinOrderTicketVo = new KylinOrderTicketVo();
            kylinOrderTicketVo.setStatus(newStatus);
            BasicDBObject orderObject = new BasicDBObject("$set", JSON.parse(JsonUtils.toJson(kylinOrderTicketVo)));
            Document orderDoc = mongoTemplate.getCollection(KylinOrderTicketVo.class.getSimpleName()).findOneAndUpdate(
                    Query.query(Criteria.where("orderTicketsId").is(orderTicketsId)).getQueryObject(),
                    orderObject,
                    new FindOneAndUpdateOptions().returnDocument(ReturnDocument.AFTER)
            );
            dataUtils.delOrderTicketRedis(orderTicketsId);
            KylinOrderTickets orderInfo = kylinOrderTicketsMapper.selectOne(
                    new QueryWrapper<KylinOrderTickets>().eq("order_tickets_id", orderTicketsId)
            );
            mongoVoUtils.resetOrderListVo(orderInfo.getUserId(), 2, orderTicketsId,null);

            // 入场人
            for (String entitiesId : orderTicketEntitiesIdsArr) {
                // 订单状态表 判断是退到正在退款 已付款 部分退款？(取消，完成，失败)
                int newIsPayment = 0;
                int refundingEntitiesCount = kylinOrderRefundsMapper.selectEntitiesCount(orderTicketsId, whereRefundingCount, orderRefundsId, entitiesId);
                if (refundingEntitiesCount > 0) { // 存在其他正在退款的该入场人订单
                    newIsPayment = KylinTableStatusConst.ENTITIES_IS_PAYMENT2;
                } else {
                    KylinOrderTicketEntities entitiesInfo = kylinOrderTicketEntitiesMapper.selectOne(
                            new QueryWrapper<KylinOrderTicketEntities>().eq("order_ticket_entities_id", entitiesId)
                    );
                    if (entitiesInfo.getRefundPrice().doubleValue() > 0) { // 已经有退完的 那就是部分退款了
                        newIsPayment = KylinTableStatusConst.ENTITIES_IS_PAYMENT4;
                    } else {
                        newIsPayment = KylinTableStatusConst.ENTITIES_IS_PAYMENT1;
                    }
                }
                KylinOrderTicketEntities entitiesTable = new KylinOrderTicketEntities();
                entitiesTable.setIsPayment(newIsPayment);
                kylinOrderTicketEntitiesMapper.update(entitiesTable, new UpdateWrapper<KylinOrderTicketEntities>()
                        .eq("order_ticket_entities_id", entitiesId)
                        .eq("is_payment", KylinTableStatusConst.ENTITIES_IS_PAYMENT2)
                );

                KylinOrderTicketEntitiesVo kylinOrderTicketEntitiesVo = new KylinOrderTicketEntitiesVo();
                kylinOrderTicketEntitiesVo.setIsPayment(newIsPayment);
                BasicDBObject entitiesObject = new BasicDBObject("$set", JSON.parse(JsonUtils.toJson(kylinOrderTicketEntitiesVo)));
                Document entitiesDoc = mongoTemplate.getCollection(KylinOrderTicketEntitiesVo.class.getSimpleName()).findOneAndUpdate(
                        Query.query(Criteria.where("orderTicketEntitiesId").is(entitiesId)).getQueryObject(),
                        entitiesObject,
                        new FindOneAndUpdateOptions().returnDocument(ReturnDocument.AFTER)
                );

                dataUtils.delOrderTicketEntitiesRedis(entitiesId);
            }

            // 退款细节取消
            KylinOrderRefunds kylinOrderRefunds = new KylinOrderRefunds();
            kylinOrderRefunds.setStatus(KylinTableStatusConst.ORDER_REFUND_STATUS_CANCEL);
            kylinOrderRefunds.setUpdatedAt(LocalDateTime.now());
            kylinOrderRefundsMapper.update(kylinOrderRefunds, new UpdateWrapper<KylinOrderRefunds>()
                    .eq("order_refunds_id", orderRefundsId));

        }
        return true;
    }

    public boolean orderRefundChangeStatus(List<KylinOrderRefunds> refundList, String type, String reject, String refuse) {
        String authId = ShiroUtils.getUserId().toString();
        String authName = ShiroUtils.getLoginName();
        KylinOrderRefunds kylinOrderRefunds = new KylinOrderRefunds();

        switch (type) {
            case "reapply":
                kylinOrderRefunds.setStatus(KylinTableStatusConst.ORDER_REFUND_STATUS_APPLY);
                kylinOrderRefunds.setApplicantId(authId);
                kylinOrderRefunds.setApplicantName(authName);
                kylinOrderRefunds.setApplicantAt(LocalDateTime.now());
                break;
            case "approved":
                kylinOrderRefunds.setStatus(KylinTableStatusConst.ORDER_REFUND_STATUS_APPROVED);
                kylinOrderRefunds.setAuditorId(authId);
                kylinOrderRefunds.setAuditorName(authName);
                kylinOrderRefunds.setAuditorAt(LocalDateTime.now());
                kylinOrderRefunds.setReject(reject);
                break;
            case "reject":
                kylinOrderRefunds.setStatus(KylinTableStatusConst.ORDER_REFUND_STATUS_REJECT);
                kylinOrderRefunds.setAuditorId(authId);
                kylinOrderRefunds.setAuditorName(authName);
                kylinOrderRefunds.setAuditorAt(LocalDateTime.now());
                kylinOrderRefunds.setReject(reject);
                break;
            case "refuse":
                kylinOrderRefunds.setStatus(KylinTableStatusConst.ORDER_REFUND_STATUS_REFUSE);
                kylinOrderRefunds.setExecutorId(authId);
                kylinOrderRefunds.setExecutorName(authName);
                kylinOrderRefunds.setExecutorAt(LocalDateTime.now());
                kylinOrderRefunds.setRefuse(refuse);
                break;
        }

        List<String> orderRefundIds = refundList.stream().map(
                KylinOrderRefunds -> KylinOrderRefunds.getOrderRefundsId()).collect(Collectors.toList()
        );
        kylinOrderRefundsMapper.update(
                kylinOrderRefunds,
                new UpdateWrapper<KylinOrderRefunds>().in("order_refunds_id", orderRefundIds)
        );

        return true;
    }

    public boolean orderTicketRefundUnfilled(List<KylinOrderRefunds> refundList, String refuse) {
        String authId = ShiroUtils.getUserId().toString();
        String authName = ShiroUtils.getLoginName();

        KylinOrderRefunds kylinOrderRefunds = new KylinOrderRefunds();
        kylinOrderRefunds.setStatus(KylinTableStatusConst.ORDER_REFUND_STATUS_UNFILLED);
        kylinOrderRefunds.setExecutorId(authId);
        kylinOrderRefunds.setExecutorName(authName);
        kylinOrderRefunds.setExecutorAt(LocalDateTime.now());
        kylinOrderRefunds.setRefuse(refuse);

        for (KylinOrderRefunds refund : refundList) {
            KylinOrderTickets oderInfo = kylinOrderTicketsMapper.selectOne(
                    new QueryWrapper<KylinOrderTickets>()
                            .eq("order_tickets_id", refund.getOrderTicketsId())
            );
            double refundPrice = refund.getPrice().doubleValue() + refund.getPriceExpress().doubleValue();
            MultiValueMap<String, String> params = new LinkedMultiValueMap();
            params.add("code", oderInfo.getPayCode());
            params.add("order_refund_code", refund.getOrderRefundCode());
            params.add("price", String.valueOf(refundPrice));
            params.add("reason", refund.getReason());
            params.add("notify_url", notifyUrl);

            String sign = StringUtils.Ksort(params);
            sign = sign.concat("&key=").concat("R7tXY9smPQPG9Ku5yI0u6sfnlckmk04V");
            // sign = MD5.getStrMD5(sign);
            sign = sign.toUpperCase();
            params.add("sign", sign);

            // 请求pay
            String postResult = null;
            postResult = HttpUtil.post(applyUrl, params);
            // 更新退款表
            kylinOrderRefundsMapper.update(
                    kylinOrderRefunds,
                    new UpdateWrapper<KylinOrderRefunds>().in("order_refunds_id", refund.getOrderRefundsId())
            );
        }

        return true;
    }

    public boolean orderTicketRefunded(RefundCallbackParam refundCallbackParam, KylinOrderRefunds refundInfo) {
        List<KylinOrderRefundEntities> refundEntities = kylinOrderRefundsEntitiesMapper.selectList(
                new QueryWrapper<KylinOrderRefundEntities>().eq("order_refunds_id", refundInfo.getOrderRefundsId())
        );
        List<String> orderTicketEntitiesIdsArr = refundEntities.stream().map(KylinOrderTicketEntities -> KylinOrderTicketEntities.getOrderTicketEntitiesId()).collect(Collectors.toList());
        String orderTicketsId = refundInfo.getOrderTicketsId();

        KylinOrderTicketRelations orderRelations = kylinOrderTicketRelationsMapper.selectOne(
                new QueryWrapper<KylinOrderTicketRelations>().eq("order_id", orderTicketsId)
        );

        // 更新数据
        // 订单状态表
        KylinOrderTickets orderInfo = kylinOrderTicketsMapper.selectOne(
                new QueryWrapper<KylinOrderTickets>().eq("order_tickets_id", orderTicketsId)
        );
        KylinOrderTicketStatus orderStatusTable = new KylinOrderTicketStatus();
        int newStatus = 0;
        if (refundCallbackParam.getRefund_price() + orderInfo.getPriceRefund().doubleValue() == orderInfo.getPriceActual().doubleValue()) {
            newStatus = KylinTableStatusConst.ORDER_STATUS4;
        } else {
            newStatus = KylinTableStatusConst.ORDER_STATUS6;
        }
        orderStatusTable.setStatus(newStatus);
        orderStatusTable.setUpdatedAt(LocalDateTime.now());
        kylinOrderTicketStatusMapper.update(
                orderStatusTable, new UpdateWrapper<KylinOrderTicketStatus>()
                        .eq("order_id", orderTicketsId)
        );

        // 入场人
        double priceActual = orderInfo.getPriceActual().doubleValue();
        double priceExpress = orderInfo.getPriceExpress().doubleValue();
        int allEntitiesCount = kylinOrderTicketEntitiesMapper.selectCount(// 总入场人数量 排出未付款的 用来计算单入场人的价格
                new QueryWrapper<KylinOrderTicketEntities>()
                        .eq("order_id", orderTicketsId)
                        .ne("is_payment", KylinTableStatusConst.ENTITIES_IS_PAYMENT0)
        );
        double onePrice = (priceActual - priceExpress) / allEntitiesCount;//单价
        int refundNumber = 0;
        for (String entitiesId : orderTicketEntitiesIdsArr) {
            Double refundedPrice = kylinOrderTicketEntitiesMapper.getRefundOverEntitiesPrice(//已退完成的
                    orderTicketsId,
                    KylinTableStatusConst.ORDER_REFUND_STATUS_REFUNDED,
                    entitiesId
            );
            if (null == refundedPrice) {
                refundedPrice = 0.0;
            }
            KylinOrderRefundEntities refundEntitiesInfo = kylinOrderRefundsEntitiesMapper.selectOne(
                    new QueryWrapper<KylinOrderRefundEntities>()
                            .eq("order_refunds_id", refundInfo.getOrderRefundsId())
                            .eq("order_ticket_entities_id", entitiesId)
            );

            KylinOrderTicketEntities entitiesTable = new KylinOrderTicketEntities();
            double priceNew = refundEntitiesInfo.getRefundPrice().doubleValue() + refundedPrice.doubleValue();
            if (priceNew == onePrice) {
                entitiesTable.setIsPayment(KylinTableStatusConst.ENTITIES_IS_PAYMENT3);
                refundNumber ++;
            } else {
                entitiesTable.setIsPayment(KylinTableStatusConst.ENTITIES_IS_PAYMENT4);
            }
            entitiesTable.setUpdatedAt(LocalDateTime.now());
            entitiesTable.setRefundPrice(BigDecimal.valueOf(priceNew));
            kylinOrderTicketEntitiesMapper.update(entitiesTable, new UpdateWrapper<KylinOrderTicketEntities>()
                    .eq("order_ticket_entities_id", entitiesId)
                    .eq("is_payment", KylinTableStatusConst.ENTITIES_IS_PAYMENT2)
            );

            KylinOrderTicketEntitiesVo kylinOrderTicketEntitiesVo = new KylinOrderTicketEntitiesVo();
            if (priceNew == onePrice) {
                kylinOrderTicketEntitiesVo.setIsPayment(KylinTableStatusConst.ENTITIES_IS_PAYMENT3);
            } else {
                kylinOrderTicketEntitiesVo.setIsPayment(KylinTableStatusConst.ENTITIES_IS_PAYMENT4);
            }
            kylinOrderTicketEntitiesVo.setUpdatedAt(LocalDateTime.now().toString());
            kylinOrderTicketEntitiesVo.setRefundPrice(BigDecimal.valueOf(priceNew));
            BasicDBObject entitiesObject = new BasicDBObject("$set", JSON.parse(JsonUtils.toJson(kylinOrderTicketEntitiesVo)));
            Document entitiesDoc = mongoTemplate.getCollection(KylinOrderTicketEntitiesVo.class.getSimpleName()).findOneAndUpdate(
                    Query.query(Criteria.where("orderTicketEntitiesId").is(entitiesId)).getQueryObject(),
                    entitiesObject,
                    new FindOneAndUpdateOptions().returnDocument(ReturnDocument.AFTER)
            );

            dataUtils.delOrderTicketEntitiesRedis(entitiesId);
        }

        // 订单表
        double price = orderInfo.getPriceRefund().doubleValue() + refundCallbackParam.getRefund_price();
        Integer num = orderInfo.getRefundNumber() + refundNumber;
        KylinOrderTickets update = new KylinOrderTickets();
        update.setRefundNumber(num);
        update.setPriceRefund(BigDecimal.valueOf(price));
        update.setUpdatedAt(LocalDateTime.now());
        kylinOrderTicketsMapper.update(
                update, new UpdateWrapper<KylinOrderTickets>()
                        .eq("order_tickets_id", orderTicketsId)
        );

        KylinOrderTicketVo kylinOrderTicketVoOrder = new KylinOrderTicketVo();
        kylinOrderTicketVoOrder.setStatus(newStatus);
        kylinOrderTicketVoOrder.setRefundNumber(num);
        kylinOrderTicketVoOrder.setUpdatedAt(LocalDateTime.now().toString());
        // TODO: 2021/6/16  error
        // kylinOrderTicketVoOrder.setPriceRefund(BigDecimal.valueOf(price));
        BasicDBObject orderEntitiesObject = new BasicDBObject("$set", JSON.parse(JsonUtils.toJson(kylinOrderTicketVoOrder)));
        Document docOrder = mongoTemplate.getCollection(KylinOrderTicketVo.class.getSimpleName()).findOneAndUpdate(
                Query.query(Criteria.where("orderTicketsId").is(orderTicketsId)).getQueryObject(),
                orderEntitiesObject,
                new FindOneAndUpdateOptions().returnDocument(ReturnDocument.AFTER)
        );
        dataUtils.delOrderTicketRedis(orderTicketsId);
        mongoVoUtils.resetOrderListVo(orderInfo.getUserId(), 2, orderTicketsId,null);

        // 退款单完成
        KylinOrderRefunds kylinOrderRefunds = new KylinOrderRefunds();
        kylinOrderRefunds.setStatus(KylinTableStatusConst.ORDER_REFUND_STATUS_REFUNDED);
        kylinOrderRefunds.setRefundCode(refundCallbackParam.getRefund_code());
        kylinOrderRefunds.setRefundType(refundCallbackParam.getRefund_type());
        kylinOrderRefunds.setRefundId(refundCallbackParam.getRefund_id());
        kylinOrderRefunds.setRefundAt(refundCallbackParam.getRefund_at());
        kylinOrderRefunds.setRefundError(refundCallbackParam.getRefund_error());
        kylinOrderRefunds.setUpdatedAt(LocalDateTime.now());
        kylinOrderRefundsMapper.update(
                kylinOrderRefunds,
                new UpdateWrapper<KylinOrderRefunds>().in("order_refunds_id", refundInfo.getOrderRefundsId())
        );

        if (refundInfo.getType() == KylinTableStatusConst.ORDER_REFUND_TYPE_APPLY) {
            // 退还库存
            for (String entitiesId : orderTicketEntitiesIdsArr) {
                dataUtils.changeSurplusGeneral(entitiesId, 1);
                KylinOrderTicketEntities entitiesInfo = kylinOrderTicketEntitiesMapper.selectOne(
                        new QueryWrapper<KylinOrderTicketEntities>().eq("order_ticket_entities_id", entitiesId)
                );
                dataUtils.changeBuyInfo(orderInfo.getUserId(), "", orderRelations.getPerformanceId(), entitiesInfo.getTicketId(), -1);
            }
        }

        return true;
    }

}
