package com.liquidnet.client.admin.zhengzai.sweet.utils;

import com.liquidnet.common.cache.redis.util.RedisDataSourceUtil;
import com.liquidnet.service.sweet.constant.SweetConstant;
import com.liquidnet.service.sweet.dto.vo.IntegralActivityDrawVo;
import com.liquidnet.service.sweet.dto.vo.IntegralActivityVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.LinkedList;
import java.util.List;

@Component
public class SweetRedisAdminUtils {

    @Autowired
    private RedisDataSourceUtil redisDataSourceUtil;

    public void setIntegralActivityList(List<IntegralActivityVo> voList) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_INTEGRAL_ACTIVITY_LIST;
        boolean set = redisDataSourceUtil.getRedisSweetUtil().set(redisKey, voList);
    }

    public void setIntegralActivityInfo(IntegralActivityVo integralActivityVo) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_INTEGRAL_ACTIVITY_INFO.concat(integralActivityVo.getIntegralActivityId());
        boolean set = redisDataSourceUtil.getRedisSweetUtil().set(redisKey, integralActivityVo);
    }

    public void incrIntegralActivityPrizeNum(String integralActivityId, String prizeId, Integer num) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_INTEGRAL_ACTIVITY_PRIZE_NUM
                .concat(integralActivityId)
                .concat(SweetConstant.REDIS_KEY_SWEET_INTEGRAL_ACTIVITY_PRIZE_ID)
                .concat(prizeId);
        redisDataSourceUtil.getRedisSweetUtil().incr(redisKey, num);
    }

    public void decrIntegralActivityPrizeNum(String integralActivityId, String prizeId, Integer num) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_INTEGRAL_ACTIVITY_PRIZE_NUM
                .concat(integralActivityId)
                .concat(SweetConstant.REDIS_KEY_SWEET_INTEGRAL_ACTIVITY_PRIZE_ID)
                .concat(prizeId);
        redisDataSourceUtil.getRedisSweetUtil().decr(redisKey, num);
    }

    public void setIntegralActivityDraw(LinkedList<IntegralActivityDrawVo> sweetIntegralActivityDraws, String integralActivityId, String userId) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_INTEGRAL_ACTIVITY_DRAW_IN_USER
                .concat(integralActivityId)
                .concat(":userId:")
                .concat(userId);
        redisDataSourceUtil.getRedisSweetUtil().set(redisKey, sweetIntegralActivityDraws);
    }

    public void setIntegralActivityDrawInfo(String drawId) {
        String redisKeyDraw = SweetConstant.REDIS_KEY_SWEET_INTEGRAL_ACTIVITY_DRAW_INFO
                .concat(drawId);
        IntegralActivityDrawVo info = (IntegralActivityDrawVo) redisDataSourceUtil.getRedisSweetUtil().get(redisKeyDraw);
        info.setReceivingStatus(2);
        redisDataSourceUtil.getRedisSweetUtil().set(redisKeyDraw, info);
    }
}
