package com.liquidnet.client.admin.zhengzai.smile.service.impl;


import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.client.admin.common.utils.StringUtils;
import com.liquidnet.client.admin.zhengzai.smile.service.ISmileAgentService;
import com.liquidnet.client.admin.zhengzai.smile.utils.SmileRedisUtils;
import com.liquidnet.service.goblin.constant.SmileRedisConst;
import com.liquidnet.service.goblin.dto.vo.SmileAgentVo;
import com.liquidnet.service.kylin.entity.KylinTickets;
import com.liquidnet.service.kylin.mapper.KylinTicketsMapper;
import com.liquidnet.service.smile.entity.SmileAgent;
import com.liquidnet.service.smile.mapper.SmileAgentMapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2022-03-16
 */
@Service
@Slf4j
public class SmileAgentServiceImpl extends ServiceImpl<SmileAgentMapper, SmileAgent> implements ISmileAgentService {

    @Autowired
    SmileAgentMapper smileAgentMapper;

    @Autowired
    SmileRedisUtils smileRedisUtils;

    @Autowired
    KylinTicketsMapper kylinTicketsMapper;

    @Override
    public SmileAgent listAgentByShowIdAndTicketId(String performanceId, String ticketId) {
        if (StringUtils.isNotEmpty(performanceId) && StringUtils.isNotEmpty(ticketId)) {
            LambdaQueryWrapper<SmileAgent> queryWrapper = Wrappers.lambdaQuery(SmileAgent.class);
            queryWrapper.eq(SmileAgent::getPerformanceId, performanceId);
            queryWrapper.eq(SmileAgent::getTicketId, ticketId);
            smileAgentMapper.selectOne(queryWrapper);
            return null;
        }
        return null;
    }

    @Override
    public boolean create(List<SmileAgent> smileAgents) {
        boolean result = true;
        if (StringUtils.isNotEmpty(smileAgents)) {
            for (SmileAgent agent : smileAgents) {
                result = !StringUtils.isEmpty(agent.getPerformanceId()) && !StringUtils.isEmpty(agent.getTicketId());
            }
            if (result) {
                try {
                    smileAgents.forEach(smileAgent -> {
                        //是否是修改票提
                        LambdaQueryWrapper<SmileAgent> queryWrapper = Wrappers.lambdaQuery(SmileAgent.class);
                        queryWrapper.eq(SmileAgent::getPerformanceId, smileAgent.getPerformanceId());
                        queryWrapper.eq(SmileAgent::getTicketId, smileAgent.getTicketId());
                        if (smileAgentMapper.selectOne(queryWrapper) != null) {
                            //修改
                            smileAgentMapper.update(smileAgent, queryWrapper);
                            SmileAgentVo smileAgentVo = new SmileAgentVo();
                            BeanUtils.copyProperties(smileAgent, smileAgentVo);
                            smileRedisUtils.set(SmileRedisConst.SMILE_AGENT.concat(smileAgent.getPerformanceId()).concat(":").concat(smileAgent.getTicketId()), smileAgentVo);
                            log.debug("create update Agent id：{},PerformanceId:{},TicketId:{}",
                                    smileAgent.getId(),
                                    smileAgent.getPerformanceId(),
                                    smileAgent.getTicketId());
                        } else {
                            //新增
                            smileAgentMapper.insert(smileAgent);
                            SmileAgentVo smileAgentVo = new SmileAgentVo();
                            BeanUtils.copyProperties(smileAgent, smileAgentVo);
                            smileRedisUtils.set(SmileRedisConst.SMILE_AGENT.concat(smileAgent.getPerformanceId()).concat(":").concat(smileAgent.getTicketId()), smileAgentVo);
                            log.debug("create create Agent id：{},PerformanceId:{},TicketId:{}",
                                    smileAgent.getId(),
                                    smileAgent.getPerformanceId(),
                                    smileAgent.getTicketId());
                        }
                    });
                    return true;
                } catch (Exception e) {
                    e.printStackTrace();
                    return false;
                }
            }
        }
        return false;
    }

    @Override
    public String getAgent(String performancesId) {
        //从redis取出开启代理的票id
//        smileRedisUtils.lSet(SmileRedisConst.SMILE_SHOW.concat(":performancesId"),ticketId);
        List<Object> ticketsList = smileRedisUtils.lGet(SmileRedisConst.SMILE_SHOW.concat(":").concat(performancesId), 0, -1);
        if (StringUtils.isNotEmpty(ticketsList)) {
            for (Object tickets : ticketsList) {
                //根据票id查询票名及其
                LambdaQueryWrapper<KylinTickets> queryWrapper = Wrappers.lambdaQuery(KylinTickets.class);
                queryWrapper.eq(KylinTickets::getTicketsId,tickets);
                KylinTickets kylinTickets = kylinTicketsMapper.selectOne(queryWrapper);

            }
        }

        return null;
    }
}
