package com.liquidnet.service.consumer.slowly.config;

import com.liquidnet.common.cache.redis.config.RedisStreamConfig;
import com.liquidnet.service.base.constant.MQConst;
import com.liquidnet.service.consumer.slowly.receiver.ConsumerSlimeStep2RdsReceiver;
import lombok.var;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.stream.Consumer;
import org.springframework.data.redis.connection.stream.MapRecord;
import org.springframework.data.redis.connection.stream.ReadOffset;
import org.springframework.data.redis.connection.stream.StreamOffset;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.stream.StreamMessageListenerContainer;
import org.springframework.data.redis.stream.Subscription;

import java.util.ArrayList;
import java.util.List;

@Configuration
public class ConsumerSlimeStep2RedisStreamConfig extends RedisStreamConfig {
    @Autowired
    ConsumerSlimeStep2RdsReceiver consumerSlimeStep2RdsReceiver;
    @Autowired
    StringRedisTemplate stringRedisTemplate;

    @Bean
    public List<Subscription> subscriptionSqlSlimeStep2(RedisConnectionFactory factory) {
        List<Subscription> subscriptionList = new ArrayList<>();
        MQConst.SlimeQueue stream = MQConst.SlimeQueue.SQL_SLIME_STEP2;
        this.initStream(stringRedisTemplate, stream.getKey(), stream.getGroup());
        for (int i = 0; i < 1; i++) {
            StreamMessageListenerContainer<String, MapRecord<String, String, String>> listenerContainer = this.buildStreamMessageListenerContainer(factory);
            subscriptionList.add(listenerContainer.receiveAutoAck(
                    Consumer.from(stream.getGroup(), getConsumerName(stream.name() + i)),
                    StreamOffset.create(stream.getKey(), ReadOffset.lastConsumed()), consumerSlimeStep2RdsReceiver
            ));
            listenerContainer.start();
        }
        return subscriptionList;
    }
//
//    /**
//     * 验票更新
//     *
//     * @param listenerContainer
//     * @param t
//     * @return
//     */
//    private Subscription receiveTransferResult(StreamMessageListenerContainer<String, MapRecord<String, String, String>> listenerContainer, int t) {
//        return listenerContainer.receiveAutoAck(Consumer.from(MQConst.SlimeQueue.SQL_SLIME_STEP2.getGroup(), getConsumerName(MQConst.SlimeQueue.SQL_SLIME_STEP2.name() + t)),
//                StreamOffset.create(MQConst.SlimeQueue.SQL_SLIME_STEP2.getKey(), ReadOffset.lastConsumed()), consumerSlimeStep2RdsReceiver);
//    }
//
//    /* —————————————————————————— ｜ —————————————————————————— ｜ —————————————————————————— */
//
//    /* -------------------------------------------------------- ｜ 验票更新 */
//
//    @Bean
//    public Subscription subscriptionReceiveStep20(RedisConnectionFactory factory) {
//        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
//        var subscription = receiveTransferResult(listenerContainer, 0);
//        listenerContainer.start();
//        return subscription;
//    }

//    @Bean
//    public Subscription subscriptionReceiveStep21(RedisConnectionFactory factory) {
//        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
//        var subscription = receiveTransferResult(listenerContainer, 1);
//        listenerContainer.start();
//        return subscription;
//    }
//
//    @Bean
//    public Subscription subscriptionReceiveStep22(RedisConnectionFactory factory) {
//        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
//        var subscription = receiveTransferResult(listenerContainer, 2);
//        listenerContainer.start();
//        return subscription;
//    }

//    @Bean
//    public Subscription subscriptionReceiveStep23(RedisConnectionFactory factory) {
//        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
//        var subscription = receiveTransferResult(listenerContainer, 3);
//        listenerContainer.start();
//        return subscription;
//    }
//
//    @Bean
//    public Subscription subscriptionReceiveStep24(RedisConnectionFactory factory) {
//        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
//        var subscription = receiveTransferResult(listenerContainer, 4);
//        listenerContainer.start();
//        return subscription;
//    }

    /* -------------------------------------------------------- ｜  */
}
