package com.liquidnet.service.sweet.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.*;
import java.io.Serializable;

@ApiModel(value = "SweetOpenSendMsgParam", description = "发送模版消息公共接口入参")
@Data
public class SweetOpenSendMsgParam implements Serializable {

    private static final long serialVersionUID = 675588088506034208L;

    @ApiModelProperty(position = 11, required = true, allowableValues = "1,2", value = "发送目标类型 1正在服务号 2摩登服务号")
    @NotNull(message = "sendTargetType不能为空") @Min(value = 1, message = "sendTargetType无效") @Max(value = 2, message = "sendTargetType无效")
    private Integer sendTargetType;

    @ApiModelProperty(position = 12, required = true, value = "模版消息ID", example = "")
    @NotBlank(message = "templateId不能为空")
    private String templateId;

    @ApiModelProperty(position = 13, required = true, value = "模版消息数据", example = "{\"sendTargetType\": 1, \"jumpType\": \"5\"}")
    @NotBlank(message = "templateData不能为空")
    private String templateData;

    @ApiModelProperty(position = 14, required = true, allowableValues = "1,2,3,4,5", value = "点击跳转类型 1草莓小程序 2五百里小程序 3mdsk小程序 4正在小程序 5url", example = "")
    @NotNull(message = "jumpType不能为空") @Min(value = 1, message = "jumpType无效") @Max(value = 5, message = "jumpType无效")
    private Integer jumpType;

    @ApiModelProperty(position = 15, value = "跳转url", example = "www.zhengzai.tv")
    private String jumpUrl;

    @ApiModelProperty(position = 16, allowableValues = "false,true", value = "是否需要前端配合处理跳转", example = "false")
    private Boolean jumpAppletUsePath;

    @ApiModelProperty(position = 17, value = "跳转小程序需要的某页地址", example = "pages/webview?query=lottery")
    private String jumpAppletPagePath;

}
