package com.liquidnet.service.sweet.entity;

import java.math.BigDecimal;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;

import java.time.LocalDateTime;
import java.io.Serializable;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 积分活动奖品表
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-10-20
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class SweetIntegralActivityPrize implements Serializable, Cloneable {

    private static final long serialVersionUID = -3723467937911946082L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    /**
     * 奖品id
     */
    private String prizeId;

    /**
     * 关联活动id
     */
    private String integralActivityId;

    /**
     * 奖品名称
     */
    private String prizeTitle;

    /**
     * 初始展示奖品图片
     */
    private String prizeImgInit;

    /**
     * 中奖选中奖品图片
     */
    private String prizeImgSelect;

    /**
     * 奖品类型 1谢谢惠顾 2积分 3代金券 4满减券 5优先购买券 6实物
     */
    private Integer prizeType;

    /**
     * 单次奖励数量如积分 中奖给多少物
     */
    private Integer prizeTypeNum;

    /**
     * 关联id 如商品id 券id
     */
    private String relationId;

    /**
     * 奖品数量
     */
    private Integer prizeNum;

    /**
     * 限制的中奖人数
     */
    private Integer winnersNum;

    /**
     * 中奖概率
     */
    private BigDecimal winningProbability;

    /**
     * 创建时间
     */
    private LocalDateTime createdAt;

    /**
     * 更新时间
     */
    private LocalDateTime updatedAt;

    private static final SweetIntegralActivityPrize obj = new SweetIntegralActivityPrize();

    public static SweetIntegralActivityPrize getNew() {
        try {
            return (SweetIntegralActivityPrize) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new SweetIntegralActivityPrize();
        }
    }

}
