package com.liquidnet.service.kylin.dto.vo.returns;

import com.liquidnet.service.kylin.dto.vo.mongo.KylinOrderTicketVo;
import com.liquidnet.service.kylin.entity.KylinFields;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.liquidnet.service.kylin.entity.KylinOrderCoupons;
import lombok.Data;

import java.util.List;

@Data
@ApiModel(value = "OrderDetailsVo", description = "订单详情外层数据")
public class OrderDetailsVo implements Cloneable {
    @ApiModelProperty(position = 10, value = "订单详情vo")
    private KylinOrderTicketVo orderTicketVo;
    @ApiModelProperty(position = 10, value = "入场须知")
    private String enterDescribe;
    @ApiModelProperty(position = 10, value = "快递状态")
    private Integer expressStatus;
    @ApiModelProperty(position = 10, value = "订单失效时间")
    private Long restTime;
    @ApiModelProperty(position = 10, value = "订单转赠失效时间")
    private Long restTransferTime;
    @ApiModelProperty(position = 10, value = "是否可退款")
    private Integer isCanRefund;
    @ApiModelProperty(position = 10, value = "是否展示二维码")
    private Integer isShowQrCode;
    @ApiModelProperty(position = 10, value = "二维码显示时间")
    private String showQrCodeTime;
    @ApiModelProperty(position = 10, value = "是否可转赠")
    private Integer isCanTransfer;
    @ApiModelProperty(position = 10, value = "是否可回退")
    private Integer isCanBack;
    @ApiModelProperty(position = 10, value = "退款相关list")
    private List<KylinOrderRefundsOrderCodeVo> orderRefundsVoList;
    private List<KylinOrderCoupons> orderCouponsList;

    @ApiModelProperty(value = "联系方式")
    private String userMobile;

    private static final OrderDetailsVo obj = new OrderDetailsVo();

    public static OrderDetailsVo getNew() {
        try {
            return (OrderDetailsVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new OrderDetailsVo();
        }
    }
}
