package com.liquidnet.service.executor.main.handler;

import com.liquidnet.service.feign.platform.task.FeignPlatformGoblinTaskClient;
import com.xxl.job.core.context.XxlJobHelper;
import com.xxl.job.core.handler.annotation.XxlJob;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * platform:goblin
 */
@Component
public class PlatformGoblinTaskHandler {
    @Autowired
    private FeignPlatformGoblinTaskClient feignPlatformGoblinTaskClient;

    @XxlJob(value = "sev-platform:goblinGoodsOnShelvesHandler")
    public void goblinGoodsOnShelvesHandler() {// 商城:商品预约上架
        try {
            XxlJobHelper.handleSuccess("结果：" + feignPlatformGoblinTaskClient.goodsOnShelvesHandler().toJson());
        } catch (Exception e) {
            XxlJobHelper.log(e);
            XxlJobHelper.handleFail();
        }
    }

    @XxlJob(value = "sev-platform:goblinStoreMarketActivityHandler")
    public void goblinStoreMarketActivityHandler() {// 商城:商铺活动开启关闭
        try {
            XxlJobHelper.handleSuccess("结果：" + feignPlatformGoblinTaskClient.storeMarketActivityHandler().toJson());
        } catch (Exception e) {
            XxlJobHelper.log(e);
            XxlJobHelper.handleFail();
        }
    }
    @XxlJob(value = "sev-platform:goblinSetCount")
    public void setCount() {// 设置商城 商品数量
        try {
            XxlJobHelper.handleSuccess("结果：" + feignPlatformGoblinTaskClient.setCount().toJson());
        } catch (Exception e) {
            XxlJobHelper.log(e);
            XxlJobHelper.handleFail();
        }
    }

    @XxlJob(value = "sev-platform:codeCount")
    public void codeCount() {// 兑换码定时生成
        try {
            XxlJobHelper.handleSuccess("结果：" + feignPlatformGoblinTaskClient.codeCount().toJson());
        } catch (Exception e) {
            XxlJobHelper.log(e);
            XxlJobHelper.handleFail();
        }
    }

}
