package com.liquidnet.service.feign.adam.api;

import com.liquidnet.service.adam.dto.vo.AdamAddressesVo;
import com.liquidnet.service.adam.dto.vo.AdamEntersVo;
import com.liquidnet.service.base.ResponseDto;
import feign.hystrix.FallbackFactory;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Component
@FeignClient(name = "liquidnet-service-adam",
        contextId = "FeignAdamBaseClient", path = "",
        fallback = FallbackFactory.Default.class)
public interface FeignAdamBaseClient {

    @GetMapping("enters/query/depth")
    ResponseDto<AdamEntersVo> queryEnters(@RequestParam("entersId") String entersId,
                                                  @RequestParam("uid") String uid);

    @GetMapping("addr/query/depth")
    ResponseDto<AdamAddressesVo> queryAddresses(@RequestParam(value = "addrId") String addrId,
                                                        @RequestParam(value = "uid") String uid);

    /**
     * 判断是否会员
     *
     * @param uid 用户ID
     * @return 是否会员：true-是
     */
    @GetMapping("member/check/depth")
    ResponseDto<Boolean> isMember(@RequestParam("uid") String uid);
}
