package com.liquidnet.service.kylin.dto.vo;

import com.liquidnet.service.kylin.entity.KylinOrderTicketRelations;
import com.liquidnet.service.kylin.entity.KylinOrderTicketStatus;
import com.liquidnet.service.kylin.entity.KylinOrderTickets;
import lombok.Data;
import org.springframework.beans.BeanUtils;

import java.io.Serializable;
import java.math.BigDecimal;

@Data
public class KylinOrderTicketVo implements Serializable {
    private static final long serialVersionUID = 5325511589667456213L;

    private String orderTicketsId;
    private String userId;
    private String userName;
    private String userMobile;
    private String performanceTitle;
    private String orderCode;
    private String payCode;
    private String qrCode;
    private String orderType;
    private String orderVersion;
    private Integer number;
    private BigDecimal price;
    private BigDecimal priceMember;
    private BigDecimal priceTotal;
    private BigDecimal priceVoucher;
    private BigDecimal priceActual;
    private BigDecimal priceExpress;
    private BigDecimal priceRefund;
    private Integer refundNumber;
    private String payType;
    private String paymentType;
    private String timePay;
    private String expressContacts;
    private String expressAddress;
    private String expressPhone;
    private String couponType;
    private String getTicketType;
    private String getTicketDescribe;
    private Integer payCountdownMinute;

    private Integer expressType;
    private Integer isStudent;
    private Integer transferStatus;
    private Integer status;
    private Integer payStatus;

    private String transferId;
    private String liveId;
    private String performanceId;
    private String timeId;
    private String ticketId;
    private String agentId;
    private Integer isMember;

    public void setOrderTicket(KylinOrderTickets orderTicket) {
        BeanUtils.copyProperties(orderTicket,this);
    }

    public void setOrderTicketStatus(KylinOrderTicketStatus orderTicketStatus) {
        BeanUtils.copyProperties(orderTicketStatus,this);
    }

    public void setOrderTicketRelation(KylinOrderTicketRelations orderTicketRelation) {
        BeanUtils.copyProperties(orderTicketRelation,this);
    }
}
