package com.liquidnet.service.kylin.dto.vo;

import com.liquidnet.service.kylin.entity.KylinFields;
import com.liquidnet.service.kylin.entity.KylinPerformanceRelations;
import com.liquidnet.service.kylin.entity.KylinPerformanceStatus;
import com.liquidnet.service.kylin.entity.KylinPerformances;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

@ApiModel
@Data
public class KylinPerformanceVo {

    @ApiModelProperty(value = "主键")
    private String performancesId;
    @ApiModelProperty(value = "演出名称")
    private String title;
    @ApiModelProperty(value = "演出图片")
    private String imgPoster;
    @ApiModelProperty(value = "支付倒计时")
    private Integer payCountdownMinute;
    @ApiModelProperty(value = "101音乐节 102小型演出(livehouse演出) 103巡演")
//    @ApiModelProperty(value = "演出类型 1音乐节 2演唱会 3小型演出 4展览 6舞台剧 101音乐节 102小型演出(livehouse演出) 103巡演")
    private int type;
    @ApiModelProperty(value = "演出开始时间")
    private String timeStart;
    @ApiModelProperty(value = "演出结束时间")
    private String timeEnd;
    @ApiModelProperty(value = "停售时间")
    private String stopSellTime;
    @ApiModelProperty(value = "价格")
    private String price;
    @ApiModelProperty(value = "开售时间")
    private String sellTime;
    @ApiModelProperty(value = "城市id")
    private Integer cityId;
    @ApiModelProperty(value = "城市名称")
    private String cityName;
    @ApiModelProperty(value = "场地id")
    private String fieldId;
    @ApiModelProperty(value = "场地名称")
    private String fieldName;
    @ApiModelProperty(value = "经度")
    private String longitude;
    @ApiModelProperty(value = "纬度")
    private String latitude;
    @ApiModelProperty(value = "场地距离当前位置距离")
    private String diffDistance;
    @ApiModelProperty(value = "搭售id")
    private String projectId;
    @ApiModelProperty(value = "巡演id")
    private String roadShowId;

    // OSS
    @ApiModelProperty(value = "演出详情")
    private String details;
    // OSS
    @ApiModelProperty(value = "购票须知")
    private String noticeImage;

    @ApiModelProperty(value = "推荐顺序 0为不推荐")
    private Integer isRecommend;
    @ApiModelProperty(value = "状态")
    private Integer appStatus;
    @ApiModelProperty(value = "是否可买")
    private Integer statusSell;
    @ApiModelProperty(value = "是否关联会员")
    private Integer isMember;
    @ApiModelProperty(value = "是否开启缺票登记")
    private Integer isLackRegister;
    @ApiModelProperty(value = "是否实名")
    private Integer isTrueName;
    @ApiModelProperty(value = "限购张数")
    private Integer limitCount;
    @ApiModelProperty(value = "会员限购张数")
    private Integer limitCountMember;
    @ApiModelProperty(value = "是否专属")
    private Integer isExclusive;
    @ApiModelProperty(value = "是否优惠")
    private Integer isDiscount;
    @ApiModelProperty(value = "是否提前")
    private Integer isAdvance;
    @ApiModelProperty(value = "是否同步大麦 0 1")
    private Integer sysDamai;
    @ApiModelProperty(value = "文案")
    private String message;
    @ApiModelProperty(value = "巡演数据")
    private List<KylinPerformanceVo> roadList;


    public void setPerformance(KylinPerformances performance) {
        this.performancesId = performance.getPerformancesId();
        this.title = performance.getTitle();
        this.imgPoster = performance.getImgPoster();
        this.timeStart = performance.getTimeStart().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        this.timeEnd = performance.getTimeEnd().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        this.type = performance.getType();
        this.details =performance.getDetails();
        this.noticeImage = performance.getNoticeImage();
    }

    public void setTimePriceVipAndLack(int isLackRegister, int isMember, int isExclusive, BigDecimal price, LocalDateTime stopSellTime, LocalDateTime sellTime,int isAdvance,int isDiscount,int payCountdownMinute) {
        this.isLackRegister = isLackRegister;
        this.isMember = isMember;
        this.isExclusive = isExclusive;
        this.price = price + "起";
        this.stopSellTime = stopSellTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        this.sellTime = sellTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        this.appStatus = 9;
        this.isDiscount = isDiscount;
        this.isAdvance = isAdvance;
        this.message = "";
        this.payCountdownMinute = payCountdownMinute;
    }

    public void setFieldsData(KylinFields fields,String cityName){
        this.longitude = fields.getLongitude();
        this.latitude = fields.getLatitude();
        this.cityName = cityName;
        this.fieldName = fields.getName();
        this.cityId = fields.getCityId();
    }

    public void setPerformanceStatus(KylinPerformanceStatus performanceStatus) {
        this.statusSell = performanceStatus.getStatusSell();
        this.isRecommend = performanceStatus.getIsRecommend();
        this.isTrueName = performanceStatus.getIsTrueName();
        this.limitCount = performanceStatus.getLimitCount();
        this.limitCountMember = performanceStatus.getLimitCountMember();
        this.sysDamai = performanceStatus.getSyncDamai();
    }

    //TODO 巡演 搭售 场地
    public void setPerformanceRelations(KylinPerformanceRelations performanceRelations) {
        this.fieldId = performanceRelations.getFieldId();
        this.projectId = performanceRelations.getProjectId();
        this.roadShowId = performanceRelations.getRoadShowId();
    }
}
