package com.liquidnet.service.galaxy.dto.bo;

import com.liquidnet.commons.lang.util.JsonUtils;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: GalaxyNftOrderBo
 * @Package com.liquidnet.service.galaxy.dto.bo
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/3/17 11:16
 */
@Data
public class GalaxyNftOrderBo implements Serializable,Cloneable {
    private String userId;
    /**
     * 应用系统购买系列唯一ID
     */
    private String skuId;
    /**
     * 本地系列唯一名称
     */
    private String seriesName;
    /**
     * 系列的唯一Id
     */
    private String seriesId;
    /**
     * 本地系列唯一编码
     */
    private String seriesCode;
    /**
     * 接入方买入唯一标识
     */
    private String nftOrderPayId;
    /**
     * nftId
     */
    private String nftId;
    /**
     * nftId
     */
    private String nftName;
    /**
     * nft价格
     */
    private Long nftPrice;

    /**
     * nft发行任务ID
     */
    private String nftPublishTaskId;

    /**
     * 转出方地址
     */
    private String nftPublishFromAddress;

    /**
     * 转入方地址
     */
    private String nftPublishToAddress;

    /**
     * nft发行时间
     */
    private String nftPublishChainTimestamp;
    /**
     * nft发行状态
     */
    private String nftPublishStatus;
    /**
     * nft发行交易hash
     */
    private String nftPublishTradeHash;

    /**
     * nft购买任务id
     * @return
     */
    private String nftBuyTaskId;
    /**
     * 转出方地址
     */
    private String nftBuyFromAddress;

    /**
     * 转入方地址
     */
    private String nftBuyToAddress;
    /**
     * nft购买时间
     */
    private String nftBuyChainTimestamp;
    /**
     * nft购买状态
     */
    private String nftBuyStatus;
    /**
     * nft购买交易hash
     */
    private String nftBuyTradeHash;

    /**
     * nft购买支付任务ID
     * @return
     */
    private String nftBuyPayTaskId;
    /**
     * 路由类型
     */
    private String routerType;
    /**
     * 创建时间
     */
    private LocalDateTime createdAt;
    /**
     * 更新时间
     */
    private LocalDateTime updatedAt;

    @Override
    public String toString(){
        return JsonUtils.toJson(this);
    }

    private static final GalaxyNftOrderBo obj = new GalaxyNftOrderBo();

    public static GalaxyNftOrderBo getNew() {
        try {
            return (GalaxyNftOrderBo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GalaxyNftOrderBo();
        }
    }
}
